/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import org.evomaster.client.java.controller.api.dto.problem.rpc.TypeDto;

public abstract class TypeSchema {
    private final String type;
    private final String fullTypeName;
    private final Class<?> clazz;
    private Class<?> originalType;
    public int depth;

    public TypeSchema(String type, String fullTypeName, Class<?> clazz) {
        this.type = type;
        this.fullTypeName = fullTypeName;
        this.clazz = clazz;
    }

    public void setOriginalType(Class<?> originalType) {
        this.originalType = originalType;
    }

    public String getType() {
        return this.type;
    }

    public String getFullTypeName() {
        return this.fullTypeName;
    }

    public String getFullTypeNameWithGenericType() {
        return this.fullTypeName;
    }

    public abstract TypeSchema copy();

    public TypeDto getDto() {
        TypeDto dto = new TypeDto();
        dto.fullTypeName = this.fullTypeName;
        dto.fullTypeNameWithGenericType = this.getFullTypeNameWithGenericType();
        dto.depth = this.depth;
        return dto;
    }

    public boolean sameType(TypeDto dto) {
        return this.fullTypeName.equals(dto.fullTypeName);
    }

    public Class<?> getClazz() {
        return this.originalType != null ? this.originalType : this.clazz;
    }

    public String getTypeNameForInstance() {
        return this.getFullTypeNameWithGenericType();
    }
}

