/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;

public class BootTimeObjectiveInfo
implements Serializable {
    private final Map<String, Double> maxObjectiveCoverage = new ConcurrentHashMap<String, Double>(65536);
    private final List<ExternalServiceInfo> externalServiceInfo = new CopyOnWriteArrayList<ExternalServiceInfo>();

    public void reset() {
        this.maxObjectiveCoverage.clear();
        this.externalServiceInfo.clear();
    }

    public void registerExternalServiceInfoAtSutBootTime(ExternalServiceInfo info) {
        if (this.externalServiceInfo.isEmpty() || this.externalServiceInfo.stream().noneMatch(s -> s.equals(info))) {
            this.externalServiceInfo.add(info.copy());
        }
    }

    public boolean coveredAtBootTime(String descriptiveId) {
        return this.maxObjectiveCoverage.containsKey(descriptiveId) && this.maxObjectiveCoverage.get(descriptiveId) == 1.0;
    }

    public List<ExternalServiceInfo> getExternalServiceInfo() {
        return Collections.unmodifiableList(this.externalServiceInfo);
    }

    public void updateMaxObjectiveCoverage(String descriptiveId, double value) {
        Double h = this.maxObjectiveCoverage.get(descriptiveId);
        if (h == null || value > h) {
            this.maxObjectiveCoverage.put(descriptiveId, value);
        }
    }

    public Map<String, Double> getObjectiveCoverageAtSutBootTime() {
        return Collections.unmodifiableMap(this.maxObjectiveCoverage);
    }
}

