/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;

public class DateTimeParsingUtils {
    private static final double H_PARSED_OK = 1.0;
    private static final String ISO_LOCAL_TIME_PATTERN = "HH:MM:SS";
    private static final String ISO_LOCAL_DATE_PATTERN = "YYYY-MM-DD";
    private static final String ISO_LOCAL_DATE_TIME_PATTERN = String.format("%sT%s", "YYYY-MM-DD", "HH:MM:SS");
    private static final int ISO_LOCAL_TIME_LENGTH = "HH:MM:SS".length();
    private static final int ISO_LOCAL_DATE_LENGTH = "YYYY-MM-DD".length();
    private static final int ISO_LOCAL_DATE_TIME_LENGTH = ISO_LOCAL_DATE_TIME_PATTERN.length();
    private static final String DATE_TIME_NO_SECONDS_FORMAT = "YYYY-MM-DD HH:MM";

    private static double getHeuristicToLocalTimeWithoutSecondsParsing(CharSequence input) {
        Objects.requireNonNull(input);
        return DateTimeParsingUtils.getHeuristicToLocalTimeWithSecondsParsing(input + ":00");
    }

    private static double getHeuristicToLocalTimeWithSecondsParsing(CharSequence input) {
        Objects.requireNonNull(input);
        try {
            LocalTime.parse(input);
            return 1.0;
        }
        catch (DateTimeParseException ex) {
            return DateTimeParsingUtils.getHeuristicToLocalTimeWithSeconds(input);
        }
    }

    private static double getHeuristicToLocalTimeWithSeconds(CharSequence input) {
        Objects.requireNonNull(input);
        double base = 0.1;
        long distance = 0L;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (i == 0) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '1');
                continue;
            }
            if (i == 1 || i == 4 || i == 7) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '9');
                continue;
            }
            if (i == 2 || i == 5) {
                distance += (long)DistanceHelper.distanceToChar(c, ':');
                continue;
            }
            if (i == 3 || i == 6) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '5');
                continue;
            }
            distance += 65536L;
        }
        if (input.length() < ISO_LOCAL_TIME_LENGTH) {
            distance += (long)(65536 * (ISO_LOCAL_TIME_LENGTH - input.length()));
        }
        if (distance < 0L) {
            distance = Long.MAX_VALUE;
        }
        double h = DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, distance);
        return h;
    }

    public static double getHeuristicToISOLocalDateTimeParsing(CharSequence input) {
        if (input == null) {
            return 0.05;
        }
        try {
            LocalDateTime.parse(input);
            return 1.0;
        }
        catch (DateTimeParseException ex) {
            return DateTimeParsingUtils.getHeuristicToISOLocalDateTime(input);
        }
    }

    private static double getHeuristicToISOLocalDateTime(CharSequence input) {
        Objects.requireNonNull(input);
        double base = 0.1;
        long distance = 0L;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (i >= 0 && i <= 3) {
                distance += (long)DistanceHelper.distanceToDigit(c);
                continue;
            }
            if (i == 4 || i == 7) {
                distance += (long)DistanceHelper.distanceToChar(c, '-');
                continue;
            }
            if (i == 5) {
                distance += (long)DistanceHelper.distanceToChar(c, '0');
                continue;
            }
            if (i == 6) {
                distance += (long)DistanceHelper.distanceToRange(c, '1', '9');
                continue;
            }
            if (i == 8) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '2');
                continue;
            }
            if (i == 9) {
                distance += (long)DistanceHelper.distanceToRange(c, '1', '8');
                continue;
            }
            if (i == 10) {
                distance += (long)Math.min(DistanceHelper.distanceToChar(c, 'T'), DistanceHelper.distanceToChar(c, 't'));
                continue;
            }
            if (i == 11) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '1');
                continue;
            }
            if (i == 12 || i == 15 || i == 18) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '9');
                continue;
            }
            if (i == 13 || i == 16) {
                distance += (long)DistanceHelper.distanceToChar(c, ':');
                continue;
            }
            if (i == 14 || i == 17) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '5');
                continue;
            }
            distance += 65536L;
        }
        if (input.length() < ISO_LOCAL_DATE_TIME_LENGTH) {
            distance += (long)(65536 * (ISO_LOCAL_DATE_TIME_LENGTH - input.length()));
        }
        if (distance < 0L) {
            distance = Long.MAX_VALUE;
        }
        double h = DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, distance);
        return h;
    }

    public static double getHeuristicToISOLocalTimeParsing(CharSequence input) {
        if (input == null) {
            return 0.05;
        }
        return Math.max(DateTimeParsingUtils.getHeuristicToLocalTimeWithoutSecondsParsing(input), DateTimeParsingUtils.getHeuristicToLocalTimeWithSecondsParsing(input));
    }

    public static double getHeuristicToISOLocalDateParsing(CharSequence input) {
        if (input == null) {
            return 0.05;
        }
        try {
            LocalDate.parse(input);
            return 1.0;
        }
        catch (DateTimeParseException e) {
            return DateTimeParsingUtils.getHeuristicToISOLocalDate(input);
        }
    }

    private static double getHeuristicToISOLocalDate(CharSequence input) {
        Objects.requireNonNull(input);
        double base = 0.1;
        long distance = 0L;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (i >= 0 && i <= 3) {
                distance += (long)DistanceHelper.distanceToDigit(c);
                continue;
            }
            if (i == 4 || i == 7) {
                distance += (long)DistanceHelper.distanceToChar(c, '-');
                continue;
            }
            if (i == 5) {
                distance += (long)DistanceHelper.distanceToChar(c, '0');
                continue;
            }
            if (i == 6) {
                distance += (long)DistanceHelper.distanceToRange(c, '1', '9');
                continue;
            }
            if (i == 8) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '2');
                continue;
            }
            if (i == 9) {
                distance += (long)DistanceHelper.distanceToRange(c, '1', '8');
                continue;
            }
            distance += 65536L;
        }
        if (input.length() < ISO_LOCAL_DATE_LENGTH) {
            distance += (long)(65536 * (ISO_LOCAL_DATE_LENGTH - input.length()));
        }
        if (distance < 0L) {
            distance = Long.MAX_VALUE;
        }
        double h = DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, distance);
        return h;
    }

    public static double getHeuristicToDateTimeParsing(CharSequence input) {
        if (input == null) {
            return 0.05;
        }
        try {
            new SimpleDateFormat(DATE_TIME_NO_SECONDS_FORMAT).parse(input.toString());
            return 1.0;
        }
        catch (ParseException e) {
            return DateTimeParsingUtils.getHeuristicToDateTime(input);
        }
    }

    private static double getHeuristicToDateTime(CharSequence input) {
        Objects.requireNonNull(input);
        double base = 0.1;
        long distance = 0L;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (i >= 0 && i <= 3) {
                distance += (long)DistanceHelper.distanceToDigit(c);
                continue;
            }
            if (i == 4 || i == 7) {
                distance += (long)DistanceHelper.distanceToChar(c, '-');
                continue;
            }
            if (i == 5) {
                distance += (long)DistanceHelper.distanceToChar(c, '0');
                continue;
            }
            if (i == 6) {
                distance += (long)DistanceHelper.distanceToRange(c, '1', '9');
                continue;
            }
            if (i == 8) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '2');
                continue;
            }
            if (i == 9) {
                distance += (long)DistanceHelper.distanceToRange(c, '1', '8');
                continue;
            }
            if (i == 10) {
                distance += (long)DistanceHelper.distanceToChar(c, ' ');
                continue;
            }
            if (i == 11) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '1');
                continue;
            }
            if (i == 12) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '9');
                continue;
            }
            if (i == 13) {
                distance += (long)DistanceHelper.distanceToChar(c, ':');
                continue;
            }
            if (i == 14) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '5');
                continue;
            }
            if (i == 15) {
                distance += (long)DistanceHelper.distanceToRange(c, '0', '9');
                continue;
            }
            distance += 65536L;
        }
        int requiredLength = DATE_TIME_NO_SECONDS_FORMAT.length();
        if (input.length() < requiredLength) {
            distance += (long)(65536 * (requiredLength - input.length()));
        }
        if (distance < 0L) {
            distance = Long.MAX_VALUE;
        }
        double h = DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, distance);
        return h;
    }

    public static double getHeuristicToDateTimePatternParsing(String input, String dateFormatPattern) {
        if (input == null) {
            return 0.05;
        }
        try {
            new SimpleDateFormat(dateFormatPattern).parse(input);
            return 1.0;
        }
        catch (ParseException e) {
            return 0.1;
        }
    }
}

