/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementList;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;

public class MethodClassReplacement
implements MethodReplacementClass {
    private static final Set<String> toSkipCache = new CopyOnWriteArraySet<String>();

    @Override
    public Class<?> getTargetClass() {
        return Method.class;
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.EXT_0)
    public static Object invoke(Method caller, Object obj, Object ... args) throws InvocationTargetException, IllegalAccessException {
        String desc;
        if (caller == null) {
            return caller.invoke(obj, args);
        }
        caller.setAccessible(true);
        String targetClassName = caller.getDeclaringClass().getName();
        if (toSkipCache.contains(targetClassName)) {
            return caller.invoke(obj, args);
        }
        List<MethodReplacementClass> candidateClasses = ReplacementList.getReplacements(targetClassName);
        if (candidateClasses.isEmpty()) {
            toSkipCache.add(targetClassName);
            return caller.invoke(obj, args);
        }
        boolean isInSUT = false;
        String name = caller.getName();
        Optional<Method> r = ReplacementUtils.chooseMethodFromCandidateReplacement(isInSUT, name, desc = ReplacementUtils.getDescriptor(caller, 0, 0), candidateClasses, false);
        if (!r.isPresent()) {
            return caller.invoke(obj, args);
        }
        Method replacement = r.get();
        Replacement br = replacement.getAnnotation(Replacement.class);
        LinkedList<Object> tmp = new LinkedList<Object>();
        if (args != null) {
            tmp.addAll(Arrays.asList(args));
        }
        if (!br.replacingStatic()) {
            tmp.add(0, obj);
        }
        if (br.type() != ReplacementType.TRACKER) {
            tmp.add(null);
        }
        return replacement.invoke(null, tmp.toArray());
    }
}

