/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.create.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.StatementVisitor;
import shaded.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import shaded.net.sf.jsqlparser.statement.create.table.Index;
import shaded.net.sf.jsqlparser.statement.create.table.RowMovement;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;

public class CreateTable
implements Statement {
    private Table table;
    private boolean unlogged = false;
    private List<String> createOptionsStrings;
    private List<String> tableOptionsStrings;
    private List<ColumnDefinition> columnDefinitions;
    private List<String> columns;
    private List<Index> indexes;
    private Select select;
    private Table likeTable;
    private boolean selectParenthesis;
    private boolean ifNotExists = false;
    private RowMovement rowMovement;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isUnlogged() {
        return this.unlogged;
    }

    public void setUnlogged(boolean unlogged) {
        this.unlogged = unlogged;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> list) {
        this.columnDefinitions = list;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getTableOptionsStrings() {
        return this.tableOptionsStrings;
    }

    public void setTableOptionsStrings(List<String> tableOptionsStrings) {
        this.tableOptionsStrings = tableOptionsStrings;
    }

    public List<String> getCreateOptionsStrings() {
        return this.createOptionsStrings;
    }

    public void setCreateOptionsStrings(List<String> createOptionsStrings) {
        this.createOptionsStrings = createOptionsStrings;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Index> list) {
        this.indexes = list;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select, boolean parenthesis) {
        this.select = select;
        this.selectParenthesis = parenthesis;
    }

    public Table getLikeTable() {
        return this.likeTable;
    }

    public void setLikeTable(Table likeTable, boolean parenthesis) {
        this.likeTable = likeTable;
        this.selectParenthesis = parenthesis;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public boolean isSelectParenthesis() {
        return this.selectParenthesis;
    }

    public void setSelectParenthesis(boolean selectParenthesis) {
        this.selectParenthesis = selectParenthesis;
    }

    public RowMovement getRowMovement() {
        return this.rowMovement;
    }

    public void setRowMovement(RowMovement rowMovement) {
        this.rowMovement = rowMovement;
    }

    public String toString() {
        String options;
        String createOps = PlainSelect.getStringList(this.createOptionsStrings, false, false);
        String sql = "CREATE " + (this.unlogged ? "UNLOGGED " : "") + (!"".equals(createOps) ? createOps + " " : "") + "TABLE " + (this.ifNotExists ? "IF NOT EXISTS " : "") + this.table;
        if (this.columns != null && !this.columns.isEmpty()) {
            sql = sql + " ";
            sql = sql + PlainSelect.getStringList(this.columns, true, true);
        }
        if (this.columnDefinitions != null && !this.columnDefinitions.isEmpty()) {
            sql = sql + " (";
            sql = sql + PlainSelect.getStringList(this.columnDefinitions, true, false);
            if (this.indexes != null && !this.indexes.isEmpty()) {
                sql = sql + ", ";
                sql = sql + PlainSelect.getStringList(this.indexes);
            }
            sql = sql + ")";
        }
        if ((options = PlainSelect.getStringList(this.tableOptionsStrings, false, false)) != null && options.length() > 0) {
            sql = sql + " " + options;
        }
        if (this.rowMovement != null) {
            sql = sql + " " + this.rowMovement.getMode().toString() + " ROW MOVEMENT";
        }
        if (this.select != null) {
            sql = sql + " AS " + (this.selectParenthesis ? "(" : "") + this.select.toString() + (this.selectParenthesis ? ")" : "");
        }
        if (this.likeTable != null) {
            sql = sql + " LIKE " + (this.selectParenthesis ? "(" : "") + this.likeTable.toString() + (this.selectParenthesis ? ")" : "");
        }
        return sql;
    }

    public CreateTable withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public CreateTable withUnlogged(boolean unlogged) {
        this.setUnlogged(unlogged);
        return this;
    }

    public CreateTable withCreateOptionsStrings(List<String> createOptionsStrings) {
        this.setCreateOptionsStrings(createOptionsStrings);
        return this;
    }

    public CreateTable withSelectParenthesis(boolean selectParenthesis) {
        this.setSelectParenthesis(selectParenthesis);
        return this;
    }

    public CreateTable withIfNotExists(boolean ifNotExists) {
        this.setIfNotExists(ifNotExists);
        return this;
    }

    public CreateTable withRowMovement(RowMovement rowMovement) {
        this.setRowMovement(rowMovement);
        return this;
    }

    public CreateTable withTableOptionsStrings(List<String> tableOptionsStrings) {
        this.setTableOptionsStrings(tableOptionsStrings);
        return this;
    }

    public CreateTable withColumnDefinitions(List<ColumnDefinition> columnDefinitions) {
        this.setColumnDefinitions(columnDefinitions);
        return this;
    }

    public CreateTable withColumns(List<String> columns) {
        this.setColumns(columns);
        return this;
    }

    public CreateTable withIndexes(List<Index> indexes) {
        this.setIndexes(indexes);
        return this;
    }

    public CreateTable addCreateOptionsStrings(String ... createOptionsStrings) {
        List collection = Optional.ofNullable(this.getCreateOptionsStrings()).orElseGet(ArrayList::new);
        Collections.addAll(collection, createOptionsStrings);
        return this.withCreateOptionsStrings(collection);
    }

    public CreateTable addCreateOptionsStrings(Collection<String> createOptionsStrings) {
        List collection = Optional.ofNullable(this.getCreateOptionsStrings()).orElseGet(ArrayList::new);
        collection.addAll(createOptionsStrings);
        return this.withCreateOptionsStrings(collection);
    }

    public CreateTable addColumnDefinitions(ColumnDefinition ... columnDefinitions) {
        List collection = Optional.ofNullable(this.getColumnDefinitions()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columnDefinitions);
        return this.withColumnDefinitions(collection);
    }

    public CreateTable addColumnDefinitions(Collection<? extends ColumnDefinition> columnDefinitions) {
        List collection = Optional.ofNullable(this.getColumnDefinitions()).orElseGet(ArrayList::new);
        collection.addAll(columnDefinitions);
        return this.withColumnDefinitions(collection);
    }

    public CreateTable addColumns(String ... columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columns);
        return this.withColumns(collection);
    }

    public CreateTable addColumns(Collection<String> columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public CreateTable addIndexes(Index ... indexes) {
        List collection = Optional.ofNullable(this.getIndexes()).orElseGet(ArrayList::new);
        Collections.addAll(collection, indexes);
        return this.withIndexes(collection);
    }

    public CreateTable addIndexes(Collection<? extends Index> indexes) {
        List collection = Optional.ofNullable(this.getIndexes()).orElseGet(ArrayList::new);
        collection.addAll(indexes);
        return this.withIndexes(collection);
    }
}

