/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.validation.validator;

import shaded.net.sf.jsqlparser.parser.feature.Feature;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.upsert.Upsert;
import shaded.net.sf.jsqlparser.util.validation.ValidationCapability;
import shaded.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import shaded.net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpsertValidator
extends AbstractValidator<Upsert> {
    @Override
    public void validate(Upsert upsert) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.upsert);
        }
        this.validateOptionalFromItem(upsert.getTable());
        this.validateOptionalExpressions(upsert.getColumns());
        this.validateOptionalItemsList(upsert.getItemsList());
        this.validateOptionalSelect(upsert.getSelect());
        if (upsert.isUseDuplicate()) {
            this.validateDuplicate(upsert);
        }
    }

    private void validateOptionalSelect(Select select) {
        if (select != null) {
            SelectValidator v = this.getValidator(SelectValidator.class);
            if (this.isNotEmpty(select.getWithItemsList())) {
                select.getWithItemsList().forEach(with -> with.accept(v));
            }
            select.getSelectBody().accept(v);
        }
    }

    private void validateDuplicate(Upsert upsert) {
        this.validateOptionalExpressions(upsert.getDuplicateUpdateColumns());
        this.validateOptionalExpressions(upsert.getDuplicateUpdateExpressionList());
    }
}

