/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.api.dto.problem.rpc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.MockDatabaseDto;
import org.evomaster.client.java.controller.api.dto.SutInfoDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.MockRPCExternalServiceDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;

public class RPCActionDto {
    public String interfaceId;
    public String clientInfo;
    public String clientVariable;
    public String actionName;
    public List<MockRPCExternalServiceDto> mockRPCExternalServiceDtos;
    public List<MockDatabaseDto> mockDatabaseDtos;
    public List<ParamDto> requestParams;
    public ParamDto responseParam;
    public boolean isAuthorized;
    public List<Integer> requiredAuthCandidates;
    public Set<String> relatedCustomization;
    public RPCActionDto authSetup;
    public String responseVariable;
    public String controllerVariable;
    public boolean doGenerateAssertions;
    public boolean doGenerateTestScript;
    public SutInfoDto.OutputFormat outputFormat;
    public int maxAssertionForDataInCollection;
    public List<String> missingDto;

    public RPCActionDto copy() {
        RPCActionDto copy = new RPCActionDto();
        copy.interfaceId = this.interfaceId;
        copy.clientInfo = this.clientInfo;
        copy.clientVariable = this.clientVariable;
        copy.actionName = this.actionName;
        if (this.responseParam != null) {
            copy.responseParam = this.responseParam.copy();
        }
        if (this.requestParams != null) {
            copy.requestParams = this.requestParams.stream().map(ParamDto::copy).collect(Collectors.toList());
        }
        copy.responseVariable = this.responseVariable;
        copy.controllerVariable = this.controllerVariable;
        copy.doGenerateAssertions = this.doGenerateAssertions;
        copy.doGenerateTestScript = this.doGenerateTestScript;
        copy.maxAssertionForDataInCollection = this.maxAssertionForDataInCollection;
        copy.isAuthorized = this.isAuthorized;
        if (this.mockRPCExternalServiceDtos != null) {
            copy.mockRPCExternalServiceDtos = this.mockRPCExternalServiceDtos.stream().map(MockRPCExternalServiceDto::copy).collect(Collectors.toList());
        }
        if (this.mockDatabaseDtos != null) {
            copy.mockDatabaseDtos = this.mockDatabaseDtos.stream().map(MockDatabaseDto::copy).collect(Collectors.toList());
        }
        if (this.missingDto != null) {
            copy.missingDto = new ArrayList<String>(this.missingDto);
        }
        return copy;
    }

    public RPCActionDto copyComplete() {
        RPCActionDto copy = this.copy();
        if (copy.requiredAuthCandidates != null) {
            copy.requiredAuthCandidates = new ArrayList<Integer>(this.requiredAuthCandidates);
        }
        if (copy.relatedCustomization != null) {
            copy.relatedCustomization = new HashSet<String>(this.relatedCustomization);
        }
        return copy;
    }

    public String descriptiveInfo() {
        return (this.interfaceId != null ? this.interfaceId : "NULL_INTERFACE") + "::" + (this.actionName != null ? this.actionName : "NULL_ACTION_NAME") + "(" + this.requestParams.stream().map(s -> s.type.type.toString()).collect(Collectors.joining(",")) + ")";
    }
}

