/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.contentMatchers;

import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class StringCollectionMatcher
extends TypeSafeMatcher<Collection<String>> {
    private final Collection<String> stringCollection;
    private final String item;

    public StringCollectionMatcher(Collection<String> stringCollection) {
        this.stringCollection = stringCollection;
        this.item = null;
    }

    public StringCollectionMatcher(String item) {
        this.item = item;
        this.stringCollection = null;
    }

    public StringCollectionMatcher(Collection<String> stringCollection, String item) {
        this.stringCollection = stringCollection;
        this.item = item;
    }

    protected boolean matchesSafely(Collection<String> stringCollection) {
        if (this.stringCollection == null || stringCollection == null) {
            return false;
        }
        return stringCollection.containsAll(this.stringCollection) && this.stringCollection.containsAll(stringCollection);
    }

    protected boolean matchesSafely(String item) {
        if (this.stringCollection == null || item == null) {
            return false;
        }
        return this.stringCollection.contains(item);
    }

    public boolean isContainedIn(Collection<String> collection) {
        if (this.item == null || collection == null) {
            return false;
        }
        return collection.contains(this.item);
    }

    public boolean areContainedIn(Collection<String> collection) {
        if (this.stringCollection == null || collection == null) {
            return false;
        }
        return collection.containsAll(this.stringCollection);
    }

    public boolean contains(Collection<String> collection) {
        if (this.stringCollection == null || collection == null) {
            return false;
        }
        return this.stringCollection.containsAll(collection);
    }

    public void describeTo(Description description) {
        description.appendValue(this.stringCollection);
    }

    public static StringCollectionMatcher collectionContains(Collection<String> collection) {
        return new StringCollectionMatcher(collection);
    }

    public static StringCollectionMatcher collectionContains(String item) {
        return new StringCollectionMatcher(item);
    }

    public boolean collectionContainsItem(String item) {
        if (this.stringCollection == null) {
            return false;
        }
        return this.stringCollection.contains(item);
    }

    public static boolean collectionsMatch(Collection<String> firstCollection, Collection<String> secondCollection) {
        if (firstCollection == null || secondCollection == null) {
            return false;
        }
        StringCollectionMatcher n1 = new StringCollectionMatcher(firstCollection);
        return n1.matchesSafely(secondCollection);
    }

    public static boolean collectionContains(Collection<String> stringCollection, String stringItem) {
        if (stringCollection == null || stringItem == null) {
            return false;
        }
        StringCollectionMatcher n1 = new StringCollectionMatcher(stringCollection);
        return n1.collectionContainsItem(stringItem);
    }

    public static boolean collectionContains(Collection<String> stringCollection1, Collection<String> stringCollection2) {
        if (stringCollection1 == null || stringCollection2 == null) {
            return false;
        }
        StringCollectionMatcher n1 = new StringCollectionMatcher(stringCollection1);
        return n1.contains(stringCollection2);
    }

    public static boolean collectionIsContained(Collection<String> stringCollection1, Collection<String> stringCollection2) {
        if (stringCollection1 == null || stringCollection2 == null) {
            return false;
        }
        StringCollectionMatcher n1 = new StringCollectionMatcher(stringCollection1);
        return n1.areContainedIn(stringCollection2);
    }
}

