/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import org.evomaster.client.java.controller.CustomizationHandler;
import org.evomaster.client.java.controller.DtoUtils;
import org.evomaster.client.java.controller.SutHandler;
import org.evomaster.client.java.controller.api.dto.ActionDto;
import org.evomaster.client.java.controller.api.dto.ActionResponseDto;
import org.evomaster.client.java.controller.api.dto.BootTimeInfoDto;
import org.evomaster.client.java.controller.api.dto.CustomizedCallResultCode;
import org.evomaster.client.java.controller.api.dto.CustomizedRequestValueDto;
import org.evomaster.client.java.controller.api.dto.ExternalServiceInfoDto;
import org.evomaster.client.java.controller.api.dto.ExtraHeuristicsDto;
import org.evomaster.client.java.controller.api.dto.HeuristicEntryDto;
import org.evomaster.client.java.controller.api.dto.HostnameResolutionInfoDto;
import org.evomaster.client.java.controller.api.dto.MockDatabaseDto;
import org.evomaster.client.java.controller.api.dto.PostSearchActionDto;
import org.evomaster.client.java.controller.api.dto.SutInfoDto;
import org.evomaster.client.java.controller.api.dto.TargetInfoDto;
import org.evomaster.client.java.controller.api.dto.UnitsInfoDto;
import org.evomaster.client.java.controller.api.dto.auth.AuthenticationDto;
import org.evomaster.client.java.controller.api.dto.constraint.ElementConstraintsDto;
import org.evomaster.client.java.controller.api.dto.database.execution.ExecutionDto;
import org.evomaster.client.java.controller.api.dto.database.execution.SqlExecutionLogDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionResultsDto;
import org.evomaster.client.java.controller.api.dto.database.operations.MongoInsertionDto;
import org.evomaster.client.java.controller.api.dto.database.operations.MongoInsertionResultsDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.api.dto.database.schema.ExtraConstraintsDto;
import org.evomaster.client.java.controller.api.dto.problem.RPCProblemDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.EvaluatedRPCActionDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ExpandRPCInfoDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.MockRPCExternalServiceDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCActionDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCType;
import org.evomaster.client.java.controller.api.dto.problem.rpc.SeededRPCTestDto;
import org.evomaster.client.java.controller.internal.EMController;
import org.evomaster.client.java.controller.internal.TaintHandlerExecutionTracer;
import org.evomaster.client.java.controller.internal.db.MongoHandler;
import org.evomaster.client.java.controller.mongo.MongoScriptRunner;
import org.evomaster.client.java.controller.problem.ProblemInfo;
import org.evomaster.client.java.controller.problem.RPCProblem;
import org.evomaster.client.java.controller.problem.rpc.CustomizedNotNullAnnotationForRPCDto;
import org.evomaster.client.java.controller.problem.rpc.RPCEndpointsBuilder;
import org.evomaster.client.java.controller.problem.rpc.RPCExceptionHandler;
import org.evomaster.client.java.controller.problem.rpc.schema.EndpointSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.InterfaceSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.LocalAuthSetupSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.BootTimeObjectiveInfo;
import org.evomaster.client.java.instrumentation.MongoInfo;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.sql.DbCleaner;
import org.evomaster.client.java.sql.DbSpecification;
import org.evomaster.client.java.sql.SchemaExtractor;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.evomaster.client.java.sql.SqlScriptRunnerCached;
import org.evomaster.client.java.sql.internal.SqlHandler;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.core.type.TypeReference;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.org.eclipse.jetty.server.AbstractNetworkConnector;
import shaded.org.eclipse.jetty.server.Server;
import shaded.org.eclipse.jetty.server.handler.ErrorHandler;
import shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import shaded.org.eclipse.jetty.servlet.ServletHolder;
import shaded.org.glassfish.jersey.jackson.JacksonFeature;
import shaded.org.glassfish.jersey.logging.LoggingFeature;
import shaded.org.glassfish.jersey.server.ResourceConfig;
import shaded.org.glassfish.jersey.servlet.ServletContainer;

public abstract class SutController
implements SutHandler,
CustomizationHandler {
    private int controllerPort = 40100;
    private String controllerHost = "localhost";
    private final SqlHandler sqlHandler = new SqlHandler(new TaintHandlerExecutionTracer());
    private final MongoHandler mongoHandler = new MongoHandler();
    private Server controllerServer;
    private DbSchemaDto schemaDto;
    private final List<ExtraHeuristicsDto> extras = new CopyOnWriteArrayList<ExtraHeuristicsDto>();
    private final List<String> accessedTables = new CopyOnWriteArrayList<String>();
    private final Map<String, List<String>> fkMap = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> tableInitSqlMap = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, InterfaceSchema> rpcInterfaceSchema = new LinkedHashMap<String, InterfaceSchema>();
    private final List<String> jvmClassToExtract = new CopyOnWriteArrayList<String>();
    private final Map<Integer, LocalAuthSetupSchema> localAuthSetupSchemaMap = new LinkedHashMap<Integer, LocalAuthSetupSchema>();
    private ObjectMapper objectMapper;
    private int actionIndex = -1;

    public final boolean startTheControllerServer() {
        ResourceConfig config = new ResourceConfig();
        config.register((Class)JacksonFeature.class);
        config.register(new EMController(this));
        config.register((Class)LoggingFeature.class);
        this.controllerServer = new Server(InetSocketAddress.createUnresolved(this.getControllerHost(), this.getControllerPort()));
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        this.controllerServer.setErrorHandler(errorHandler);
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(config));
        ServletContextHandler context = new ServletContextHandler(this.controllerServer, "/controller/api/*");
        context.addServlet(servlet, "/*");
        try {
            this.controllerServer.start();
        }
        catch (Exception estart) {
            String msg = "Failed to start Jetty for EM Driver: " + estart.getMessage();
            SimpleLogger.error(msg);
            try {
                this.controllerServer.stop();
                this.controllerServer.destroy();
            }
            catch (Exception estop) {
                SimpleLogger.error("Failed to stop Jetty: " + estop.getMessage());
            }
            throw new RuntimeException(msg, estart);
        }
        this.newSearch();
        SimpleLogger.info("Started controller server on: " + this.controllerServer.getURI());
        return true;
    }

    public final boolean stopTheControllerServer() {
        try {
            this.controllerServer.stop();
            return true;
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to stop the controller server: " + e);
            return false;
        }
    }

    public final int getControllerServerPort() {
        return ((AbstractNetworkConnector)this.controllerServer.getConnectors()[0]).getLocalPort();
    }

    public final int getControllerPort() {
        return this.controllerPort;
    }

    public final void setControllerPort(int controllerPort) {
        this.controllerPort = controllerPort;
    }

    public final String getControllerHost() {
        return this.controllerHost;
    }

    public final void setControllerHost(String controllerHost) {
        this.controllerHost = controllerHost;
    }

    @Override
    public InsertionResultsDto execInsertionsIntoDatabase(List<InsertionDto> insertions, InsertionResultsDto ... previous) {
        Connection connection = this.getConnectionIfExist();
        if (connection == null) {
            throw new IllegalStateException("No connection to database");
        }
        try {
            return SqlScriptRunner.execInsert(connection, insertions, previous);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MongoInsertionResultsDto execInsertionsIntoMongoDatabase(List<MongoInsertionDto> insertions) {
        Object connection = this.getMongoConnection();
        if (connection == null) {
            throw new IllegalStateException("No connection to mongo database");
        }
        try {
            return MongoScriptRunner.executeInsert(connection, insertions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getActionIndex() {
        return this.actionIndex;
    }

    @Deprecated
    public final void handleSql(String sql) {
        Objects.requireNonNull(sql);
        this.sqlHandler.handle(sql);
    }

    public final void enableComputeSqlHeuristicsOrExtractExecution(boolean enableSqlHeuristics, boolean enableSqlExecution, boolean advancedHeuristics) {
        this.sqlHandler.setCalculateHeuristics(enableSqlHeuristics);
        this.sqlHandler.setExtractSqlExecution(enableSqlHeuristics || enableSqlExecution);
        this.sqlHandler.setAdvancedHeuristics(advancedHeuristics);
    }

    public final void initSqlHandler() {
        this.sqlHandler.setConnection(this.getConnectionIfExist());
        this.sqlHandler.setSchema(this.getSqlDatabaseSchema());
    }

    public final void initMongoHandler() {
        List<AdditionalInfo> list = this.getAdditionalInfoList();
        if (!list.isEmpty()) {
            AdditionalInfo last = list.get(list.size() - 1);
            last.getMongoCollectionInfoData().forEach(this.mongoHandler::handle);
        }
    }

    public final Connection getConnectionIfExist() {
        return this.getDbSpecifications() == null || this.getDbSpecifications().isEmpty() ? null : this.getDbSpecifications().get((int)0).connection;
    }

    public final boolean doEmploySmartDbClean() {
        return this.getDbSpecifications() != null && !this.getDbSpecifications().isEmpty() && this.getDbSpecifications().get((int)0).employSmartDbClean;
    }

    public final void resetExtraHeuristics() {
        this.sqlHandler.reset();
        this.mongoHandler.reset();
    }

    public final List<ExtraHeuristicsDto> getExtraHeuristics() {
        if (this.extras.size() == this.actionIndex) {
            this.extras.add(this.computeExtraHeuristics());
        }
        return new ArrayList<ExtraHeuristicsDto>(this.extras);
    }

    public final ExtraHeuristicsDto computeExtraHeuristics() {
        ExtraHeuristicsDto dto = new ExtraHeuristicsDto();
        this.computeSQLHeuristics(dto);
        this.computeMongoHeuristics(dto);
        return dto;
    }

    private void computeSQLHeuristics(ExtraHeuristicsDto dto) {
        List<AdditionalInfo> list;
        if ((this.sqlHandler.isCalculateHeuristics() || this.sqlHandler.isExtractSqlExecution()) && !(list = this.getAdditionalInfoList()).isEmpty()) {
            AdditionalInfo last = list.get(list.size() - 1);
            last.getSqlInfoData().stream().forEach(it -> {
                block2: {
                    try {
                        this.sqlHandler.handle(new SqlExecutionLogDto(it.getCommand(), it.getExecutionTime()));
                    }
                    catch (Exception e) {
                        SimpleLogger.error("FAILED TO HANDLE SQL COMMAND: " + it.getCommand());
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            });
        }
        if (this.sqlHandler.isCalculateHeuristics()) {
            this.sqlHandler.getDistances().stream().map(p -> new HeuristicEntryDto(HeuristicEntryDto.Type.SQL, HeuristicEntryDto.Objective.MINIMIZE_TO_ZERO, p.sqlCommand, p.distance)).forEach(h -> dto.heuristics.add((HeuristicEntryDto)h));
        }
        if (this.sqlHandler.isCalculateHeuristics() || this.sqlHandler.isExtractSqlExecution()) {
            ExecutionDto executionDto;
            dto.databaseExecutionDto = executionDto = this.sqlHandler.getExecutionDto();
            if (executionDto != null) {
                this.accessedTables.addAll(executionDto.deletedData);
                this.accessedTables.addAll(executionDto.insertedData.keySet());
                this.accessedTables.addAll(executionDto.insertedData.keySet());
                this.accessedTables.addAll(executionDto.updatedData.keySet());
            }
        }
    }

    public final void computeMongoHeuristics(ExtraHeuristicsDto dto) {
        AdditionalInfo last;
        List<AdditionalInfo> list = this.getAdditionalInfoList();
        if (this.mongoHandler.isCalculateHeuristics()) {
            if (!list.isEmpty()) {
                last = list.get(list.size() - 1);
                last.getMongoInfoData().forEach(it -> {
                    block2: {
                        try {
                            this.mongoHandler.handle((MongoInfo)it);
                        }
                        catch (Exception e) {
                            SimpleLogger.error("FAILED TO HANDLE MONGO COMMAND");
                            if ($assertionsDisabled) break block2;
                            throw new AssertionError();
                        }
                    }
                });
            }
            this.mongoHandler.getDistances().stream().map(p -> new HeuristicEntryDto(HeuristicEntryDto.Type.MONGO, HeuristicEntryDto.Objective.MINIMIZE_TO_ZERO, p.bson.toString(), p.distance)).forEach(h -> dto.heuristics.add((HeuristicEntryDto)h));
        }
        if (this.mongoHandler.isExtractMongoExecution()) {
            if (!list.isEmpty()) {
                last = list.get(list.size() - 1);
                last.getMongoCollectionInfoData().forEach(this.mongoHandler::handle);
            }
            dto.mongoExecutionDto = this.mongoHandler.getExecutionDto();
        }
    }

    @Override
    public final void registerOrExecuteInitSqlCommandsIfNeeded() {
        Connection connection = this.getConnectionIfExist();
        if (connection == null) {
            return;
        }
        DbSpecification dbSpecification = this.getDbSpecifications().get(0);
        if (dbSpecification == null) {
            return;
        }
        if (!dbSpecification.employSmartDbClean) {
            return;
        }
        this.tableInitSqlMap.clear();
        try {
            this.setExecutingInitSql(true);
            this.registerInitSqlCommands(connection, dbSpecification);
        }
        catch (SQLException e) {
            throw new RuntimeException("Fail to register or execute the script for initializing data in SQL database, please check specified `initSqlScript` or initSqlOnResourcePath. Error Msg:", e);
        }
        finally {
            this.setExecutingInitSql(false);
        }
    }

    public final void cleanAccessedTables() {
        if (this.getDbSpecifications() == null || this.getDbSpecifications().isEmpty()) {
            return;
        }
        if (this.getDbSpecifications().size() > 1) {
            throw new RuntimeException("Error: DO NOT SUPPORT MULTIPLE SQL CONNECTION YET");
        }
        DbSpecification emDbClean = this.getDbSpecifications().get(0);
        if (this.getConnectionIfExist() == null || !emDbClean.employSmartDbClean) {
            return;
        }
        try {
            this.setExecutingInitSql(true);
            Set tableDataToInit = null;
            if (!this.accessedTables.isEmpty()) {
                ArrayList<String> tablesToClean = new ArrayList<String>();
                this.getTableToClean(this.accessedTables, tablesToClean);
                if (!tablesToClean.isEmpty()) {
                    if (emDbClean.schemaNames != null && !emDbClean.schemaNames.isEmpty()) {
                        emDbClean.schemaNames.forEach(sch -> DbCleaner.clearDatabase(this.getConnectionIfExist(), sch, null, tablesToClean, emDbClean.dbType));
                    } else {
                        DbCleaner.clearDatabase(this.getConnectionIfExist(), null, null, tablesToClean, emDbClean.dbType);
                    }
                    tableDataToInit = tablesToClean.stream().filter(a -> this.tableInitSqlMap.keySet().stream().anyMatch(t -> t.equalsIgnoreCase((String)a))).collect(Collectors.toSet());
                }
            }
            this.handleInitSqlInDbClean(tableDataToInit, emDbClean);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQL Init Execution Error: fail to execute " + e);
        }
        finally {
            this.setExecutingInitSql(false);
        }
    }

    private void handleInitSqlInDbClean(Collection<String> tableDataToInit, DbSpecification spec) throws SQLException {
        if (tableDataToInit != null && !tableDataToInit.isEmpty()) {
            tableDataToInit.stream().sorted((s1, s2) -> this.tableFkCompartor((String)s1, (String)s2)).forEach(a -> this.tableInitSqlMap.keySet().stream().filter(t -> t.equalsIgnoreCase((String)a)).forEach(t -> this.tableInitSqlMap.get(t).forEach(c -> {
                try {
                    SqlScriptRunner.execCommand(this.getConnectionIfExist(), c);
                }
                catch (SQLException e) {
                    throw new RuntimeException("SQL Init Execution Error: fail to execute " + c + " with error " + e);
                }
            })));
        }
    }

    private void reAddAllInitSql() throws SQLException {
        if (this.tableInitSqlMap != null) {
            this.tableInitSqlMap.keySet().stream().forEach(t -> this.tableInitSqlMap.get(t).forEach(c -> {
                try {
                    SqlScriptRunner.execCommand(this.getConnectionIfExist(), c);
                }
                catch (SQLException e) {
                    throw new RuntimeException("SQL Init Execution Error: fail to execute " + c + " with error " + e);
                }
            }));
        }
    }

    private int tableFkCompartor(String tableA, String tableB) {
        return this.getFkDepth(tableA, new HashSet<String>()) - this.getFkDepth(tableB, new HashSet<String>());
    }

    private int getFkDepth(String tableName, Set<String> checked) {
        if (!this.fkMap.containsKey(tableName)) {
            return -1;
        }
        checked.add(tableName);
        List<String> fks = this.fkMap.get(tableName);
        if (fks.isEmpty()) {
            return 0;
        }
        int sum = fks.size();
        for (String fk : fks) {
            if (checked.contains(fk)) continue;
            sum += this.getFkDepth(fk, checked);
        }
        return sum;
    }

    public void addTableToInserted(List<String> tables) {
        this.accessedTables.addAll(tables);
    }

    private void getTableToClean(List<String> accessedTables, List<String> tablesToClean) {
        for (String t : accessedTables) {
            if (this.findInCollectionIgnoreCase(t, tablesToClean).isPresent()) continue;
            if (this.findInMapIgnoreCase(t, this.fkMap).isPresent()) {
                tablesToClean.add(t);
                List<String> fk = this.fkMap.entrySet().stream().filter(e -> this.findInCollectionIgnoreCase(t, (Collection)e.getValue()).isPresent() && !this.findInCollectionIgnoreCase((String)e.getKey(), tablesToClean).isPresent()).map(Map.Entry::getKey).collect(Collectors.toList());
                if (fk.isEmpty()) continue;
                this.getTableToClean(fk, tablesToClean);
                continue;
            }
            SimpleLogger.uniqueWarn("Cannot find the table " + t + " in [" + String.join((CharSequence)",", this.fkMap.keySet()) + "]");
        }
    }

    private Optional<String> findInCollectionIgnoreCase(String name, Collection<String> list) {
        return list.stream().filter(i -> i.equalsIgnoreCase(name)).findFirst();
    }

    private Optional<? extends Map.Entry<String, ?>> findInMapIgnoreCase(String name, Map<String, ?> list) {
        return list.entrySet().stream().filter(x -> ((String)x.getKey()).equalsIgnoreCase(name)).findFirst();
    }

    private boolean registerInitSqlCommands(Connection connection, DbSpecification dbSpecification) throws SQLException {
        if (dbSpecification.initSqlOnResourcePath == null && dbSpecification.initSqlScript == null) {
            return false;
        }
        ArrayList<String> all = new ArrayList<String>();
        if (dbSpecification.initSqlOnResourcePath != null) {
            all.addAll(SqlScriptRunnerCached.extractSqlScriptFromResourceFile(dbSpecification.initSqlOnResourcePath));
        }
        if (dbSpecification.initSqlScript != null) {
            all.addAll(SqlScriptRunner.extractSql(dbSpecification.initSqlScript));
        }
        if (!all.isEmpty()) {
            this.tableInitSqlMap.putAll(SqlScriptRunner.extractSqlTableMap(all));
            SqlScriptRunner.runCommands(connection, all);
            return true;
        }
        return false;
    }

    private void cleanDataInDbConnection(Connection connection, DbSpecification dbSpecification) {
        if (dbSpecification.schemaNames != null && !dbSpecification.schemaNames.isEmpty()) {
            dbSpecification.schemaNames.forEach(sch -> DbCleaner.clearDatabase(connection, sch, null, dbSpecification.dbType));
        } else {
            DbCleaner.clearDatabase(connection, null, dbSpecification.dbType);
        }
    }

    public final DbSchemaDto getSqlDatabaseSchema() {
        if (this.schemaDto != null) {
            return this.schemaDto;
        }
        if (this.getDbSpecifications() == null || this.getDbSpecifications().isEmpty()) {
            return null;
        }
        try {
            this.schemaDto = SchemaExtractor.extract(this.getConnectionIfExist());
            Objects.requireNonNull(this.schemaDto);
            this.schemaDto.employSmartDbClean = this.doEmploySmartDbClean();
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to extract the SQL Database Schema: " + e.getMessage(), e);
            return null;
        }
        if (this.fkMap.isEmpty()) {
            this.schemaDto.tables.forEach(t -> {
                this.fkMap.putIfAbsent(t.name, new ArrayList());
                if (t.foreignKeys != null && !t.foreignKeys.isEmpty()) {
                    t.foreignKeys.forEach(f -> this.fkMap.get(t.name).add(f.targetTable.toUpperCase()));
                }
            });
        }
        UnitsInfoDto unitsInfoDto = this.getUnitsInfoDto();
        List<ExtraConstraintsDto> extra = unitsInfoDto.extraDatabaseConstraintsDtos;
        if (extra != null && !extra.isEmpty()) {
            this.schemaDto.extraConstraintDtos = new ArrayList<ExtraConstraintsDto>();
            this.schemaDto.extraConstraintDtos.addAll(extra);
        }
        return this.schemaDto;
    }

    public final Map<String, InterfaceSchema> getRPCSchema() {
        return this.rpcInterfaceSchema;
    }

    public Map<Integer, LocalAuthSetupSchema> getLocalAuthSetupSchemaMap() {
        return this.localAuthSetupSchemaMap;
    }

    public RPCProblemDto extractRPCProblemDto(boolean isSutRunning) {
        RPCProblemDto rpcProblem = new RPCProblemDto();
        this.extractRPCSchema();
        Map<String, InterfaceSchema> rpcSchemas = this.getRPCSchema();
        if (rpcSchemas == null || rpcSchemas.isEmpty()) {
            throw new RuntimeException("Fail to extract RPC interface schema");
        }
        Map<Integer, LocalAuthSetupSchema> localMap = this.getLocalAuthSetupSchemaMap();
        if (localMap != null && !localMap.isEmpty()) {
            rpcProblem.localAuthEndpointReferences = new ArrayList<Integer>();
            rpcProblem.localAuthEndpoints = new ArrayList<RPCActionDto>();
            for (Map.Entry<Integer, LocalAuthSetupSchema> e : localMap.entrySet()) {
                rpcProblem.localAuthEndpointReferences.add(e.getKey());
                rpcProblem.localAuthEndpoints.add(e.getValue().getDto());
            }
        }
        rpcProblem.seededTestDtos = this.handleSeededTests(isSutRunning);
        rpcProblem.schemas = rpcSchemas.values().stream().map(s -> s.getDto()).collect(Collectors.toList());
        return rpcProblem;
    }

    @Override
    public final void extractRPCSchema() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        if (!this.rpcInterfaceSchema.isEmpty()) {
            return;
        }
        if (!(this.getProblemInfo() instanceof RPCProblem)) {
            SimpleLogger.error("Problem (" + this.getProblemInfo().getClass().getSimpleName() + ") is not RPC but request RPC schema.");
            return;
        }
        try {
            RPCEndpointsBuilder.validateCustomizedValueInRequests(this.getCustomizedValueInRequests());
            RPCEndpointsBuilder.validateCustomizedNotNullAnnotationForRPCDto(this.specifyCustomizedNotNullAnnotation());
            RPCProblem rpcp = (RPCProblem)this.getProblemInfo();
            for (String interfaceName : rpcp.getKeysOfMapOfInterfaceAndClient()) {
                InterfaceSchema schema = RPCEndpointsBuilder.build(interfaceName, rpcp.getType(), rpcp.getClient(interfaceName), rpcp.getSkipEndpointsByName() != null ? rpcp.getSkipEndpointsByName().get(interfaceName) : null, rpcp.getSkipEndpointsByAnnotation() != null ? rpcp.getSkipEndpointsByAnnotation().get(interfaceName) : null, rpcp.getInvolveEndpointsByName() != null ? rpcp.getInvolveEndpointsByName().get(interfaceName) : null, rpcp.getInvolveEndpointsByAnnotation() != null ? rpcp.getInvolveEndpointsByAnnotation().get(interfaceName) : null, this.getInfoForAuthentication(), this.getCustomizedValueInRequests(), this.specifyCustomizedNotNullAnnotation());
                this.rpcInterfaceSchema.put(interfaceName, schema);
            }
            this.localAuthSetupSchemaMap.clear();
            Map<Integer, LocalAuthSetupSchema> local = RPCEndpointsBuilder.buildLocalAuthSetup(this.getInfoForAuthentication());
            if (local != null && !local.isEmpty()) {
                this.localAuthSetupSchemaMap.putAll(local);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract the RPC Schema: " + e.getMessage());
        }
    }

    public Map<String, List<RPCActionDto>> handleSeededTests(boolean isSUTRunning) {
        List<SeededRPCTestDto> seedRPCTests;
        try {
            seedRPCTests = this.seedRPCTests();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot process the implemented method 'seedRPCTests' due to ", e);
        }
        if (seedRPCTests == null || seedRPCTests.isEmpty()) {
            return null;
        }
        if (this.rpcInterfaceSchema.isEmpty()) {
            throw new IllegalStateException("empty RPC interface: The RPC interface schemas are not extracted yet");
        }
        ProblemInfo rpcp = this.getProblemInfo();
        if (!(rpcp instanceof RPCProblem)) {
            throw new IllegalStateException("EM driver RPC: the specified problem is not RPC");
        }
        RPCType rpcType = ((RPCProblem)rpcp).getType();
        return RPCEndpointsBuilder.buildSeededTest(this.rpcInterfaceSchema, seedRPCTests, rpcType);
    }

    @Deprecated
    public final boolean verifySqlConnection() {
        return true;
    }

    public abstract void newSearch();

    public void postSearchAction(PostSearchActionDto dto) {
        try {
            if (dto != null && dto.rpcTests != null && !dto.rpcTests.isEmpty()) {
                dto.rpcTests.forEach(s -> this.customizeRPCTestOutput(s.externalServiceDtos, s.sqlInsertions, s.actions));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("fail to customize RPC Test outputs:", e);
        }
    }

    public final void newTest() {
        this.actionIndex = -1;
        this.resetExtraHeuristics();
        this.extras.clear();
        this.accessedTables.clear();
        this.newTestSpecificHandler();
        this.setExecutingAction(false);
    }

    public final void newAction(ActionDto dto) {
        if (dto.index > this.extras.size()) {
            this.extras.add(this.computeExtraHeuristics());
        }
        this.actionIndex = dto.index;
        this.resetExtraHeuristics();
        this.newActionSpecificHandler(dto);
    }

    public final void executeHandleLocalAuthenticationSetup(RPCActionDto dto, ActionResponseDto responseDto) {
        LocalAuthSetupSchema endpointSchema = new LocalAuthSetupSchema();
        endpointSchema.setValue(dto);
        this.handleLocalAuthenticationSetup(endpointSchema.getAuthenticationInfo());
        if (dto.responseVariable != null && dto.doGenerateTestScript && DtoUtils.isJavaOrKotlin(dto.outputFormat)) {
            responseDto.testScript = endpointSchema.newInvocationWithJavaOrKotlin(dto.responseVariable, dto.controllerVariable, dto.clientVariable, dto.outputFormat);
        }
    }

    public final void executeAction(RPCActionDto dto, ActionResponseDto responseDto) {
        Object response;
        EndpointSchema endpointSchema = this.getEndpointSchema(dto);
        if (dto.responseVariable != null && dto.doGenerateTestScript) {
            if (dto.outputFormat == null) {
                throw new IllegalArgumentException("When doGenerateTestScript is specified as True, outputFormat cannot be null");
            }
            if (DtoUtils.isJavaOrKotlin(dto.outputFormat)) {
                try {
                    responseDto.testScript = endpointSchema.newInvocationWithJavaOrKotlin(dto.responseVariable, dto.controllerVariable, dto.clientVariable, dto.outputFormat);
                }
                catch (Exception e) {
                    assert (false);
                    SimpleLogger.warn("Fail to generate test script " + e.getMessage());
                }
                if (responseDto.testScript == null) {
                    SimpleLogger.warn("Null test script for action " + dto.actionName);
                }
            }
        }
        try {
            Boolean ok;
            if (!(dto.mockRPCExternalServiceDtos == null || dto.mockRPCExternalServiceDtos.isEmpty() || (ok = this.handleCustomizedMethod(() -> this.customizeMockingRPCExternalService(dto.mockRPCExternalServiceDtos, true))) != null && ok.booleanValue())) {
                SimpleLogger.warn("Warning: Fail to start mocked instances of RPC-based external services with the customized method");
            }
            if (!(dto.mockDatabaseDtos == null || dto.mockDatabaseDtos.isEmpty() || (ok = this.handleCustomizedMethod(() -> this.customizeMockingDatabase(dto.mockDatabaseDtos, true))) != null && ok.booleanValue())) {
                SimpleLogger.warn("Warning: Fail to start mocked instances of databases with the customized method");
            }
            response = this.executeRPCEndpoint(dto, false);
            this.expandMockObjectIfNeeded(dto, responseDto);
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR: target exception should be caught, but " + e.getMessage());
        }
        finally {
            if (dto.mockRPCExternalServiceDtos != null && !dto.mockRPCExternalServiceDtos.isEmpty()) {
                this.handleCustomizedMethod(() -> this.customizeMockingRPCExternalService(dto.mockRPCExternalServiceDtos, false));
            }
            if (dto.mockDatabaseDtos != null && !dto.mockDatabaseDtos.isEmpty()) {
                this.handleCustomizedMethod(() -> this.customizeMockingDatabase(dto.mockDatabaseDtos, false));
            }
        }
        if (response instanceof Exception) {
            try {
                Map<Class, Integer> levelsMap = null;
                try {
                    levelsMap = this.getExceptionImportanceLevels();
                }
                catch (Throwable e) {
                    SimpleLogger.error("ERROR: fail to get specified importance levels for exceptions " + e.getMessage());
                }
                RPCExceptionHandler.handle(response, responseDto, endpointSchema, this.getRPCType(dto), levelsMap);
                return;
            }
            catch (Exception e) {
                SimpleLogger.error("ERROR: fail to handle exception instance to dto " + e.getMessage());
            }
        }
        if (endpointSchema.getResponse() != null) {
            NamedTypedValue resSchema = endpointSchema.getResponse().copyStructureWithProperties();
            if (response != null) {
                try {
                    resSchema.setValueBasedOnInstance(response);
                    responseDto.rpcResponse = resSchema.getDto();
                    if (dto.doGenerateAssertions && dto.responseVariable != null && DtoUtils.isJavaOrKotlin(dto.outputFormat)) {
                        try {
                            responseDto.assertionScript = resSchema.newAssertionWithJavaOrKotlin(dto.responseVariable, dto.maxAssertionForDataInCollection, DtoUtils.isJava(dto.outputFormat));
                        }
                        catch (Exception e) {
                            assert (false);
                            SimpleLogger.error("ERROR: fail to handle assertion generations with the given response " + e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    SimpleLogger.error("ERROR: fail to set successful response instance value to dto " + e.getMessage());
                }
                try {
                    responseDto.customizedCallResultCode = this.categorizeBasedOnResponse(response);
                }
                catch (Exception e) {
                    SimpleLogger.error("ERROR: fail to categorize result with implemented categorizeBasedOnResponse " + e.getMessage());
                }
            } else if (dto.doGenerateAssertions && dto.responseVariable != null && DtoUtils.isJavaOrKotlin(dto.outputFormat)) {
                responseDto.assertionScript = resSchema.newAssertionWithJavaOrKotlin(dto.responseVariable, dto.maxAssertionForDataInCollection, DtoUtils.isJava(dto.outputFormat));
            }
        }
    }

    private <T> T handleCustomizedMethod(Supplier<T> call) {
        try {
            return call.get();
        }
        catch (Throwable e) {
            SimpleLogger.error("ERROR: Fail to process mocking with customized method:", e);
            return null;
        }
    }

    private Object executeRPCEndpoint(RPCActionDto dto, boolean throwTargetException) throws Exception {
        Object client = ((RPCProblem)this.getProblemInfo()).getClient(dto.interfaceId);
        EndpointSchema endpointSchema = this.getEndpointSchema(dto);
        return this.executeRPCEndpointCatchTargetException(client, endpointSchema, throwTargetException);
    }

    private Object executeRPCEndpointCatchTargetException(Object client, EndpointSchema endpoint, boolean throwTargetException) throws Exception {
        Object res;
        try {
            res = this.executeRPCEndpoint(client, endpoint);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("EM RPC REQUEST EXECUTION ERROR: fail to process a RPC request with " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (throwTargetException) {
                throw (Exception)e.getTargetException();
            }
            res = e.getTargetException();
        }
        catch (Exception e) {
            SimpleLogger.error("ERROR: other exception exists " + e.getMessage());
            if (throwTargetException) {
                throw e;
            }
            res = e;
        }
        return res;
    }

    @Override
    public Object executeRPCEndpoint(String json) throws Exception {
        try {
            RPCActionDto dto = this.objectMapper.readValue(json, RPCActionDto.class);
            return this.executeRPCEndpoint(dto, true);
        }
        catch (JsonProcessingException e) {
            SimpleLogger.error("Failed to extract the json: " + e.getMessage());
            return null;
        }
    }

    private Object executeRPCEndpoint(Object client, EndpointSchema endpoint) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        if (endpoint.getRequestParams().isEmpty()) {
            Method method = client.getClass().getDeclaredMethod(endpoint.getName(), new Class[0]);
            return method.invoke(client, new Object[0]);
        }
        Object[] params = new Object[endpoint.getRequestParams().size()];
        Class[] types = new Class[endpoint.getRequestParams().size()];
        try {
            for (int i = 0; i < params.length; ++i) {
                NamedTypedValue param = endpoint.getRequestParams().get(i);
                params[i] = param.newInstance();
                types[i] = ((TypeSchema)param.getType()).getClazz();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR: fail to instance value of input parameters based on dto/schema, msg error:" + e.getMessage());
        }
        Method method = client.getClass().getDeclaredMethod(endpoint.getName(), types);
        return method.invoke(client, params);
    }

    private EndpointSchema getEndpointSchema(RPCActionDto dto) {
        InterfaceSchema interfaceSchema = this.rpcInterfaceSchema.get(dto.interfaceId);
        EndpointSchema endpointSchema = interfaceSchema.getOneEndpoint(dto).copyStructure();
        endpointSchema.setValue(dto);
        return endpointSchema;
    }

    private RPCType getRPCType(RPCActionDto dto) {
        return this.rpcInterfaceSchema.get(dto.interfaceId).getRpcType();
    }

    public abstract void newTestSpecificHandler();

    public abstract void newActionSpecificHandler(ActionDto var1);

    public abstract boolean isInstrumentationActivated();

    public abstract boolean isSutRunning();

    public abstract String getPackagePrefixesToCover();

    public abstract List<AuthenticationDto> getInfoForAuthentication();

    @Deprecated
    public final Connection getConnection() {
        throw new IllegalStateException("This deprecated method should never be called");
    }

    @Deprecated
    public final String getDatabaseDriverName() {
        throw new IllegalStateException("This deprecated method should never be called");
    }

    public abstract List<TargetInfo> getTargetInfos(Collection<Integer> var1);

    public abstract List<TargetInfo> getAllCoveredTargetInfos();

    public abstract List<AdditionalInfo> getAdditionalInfoList();

    public abstract ProblemInfo getProblemInfo();

    public abstract SutInfoDto.OutputFormat getPreferredOutputFormat();

    public abstract UnitsInfoDto getUnitsInfoDto();

    public abstract void setKillSwitch(boolean var1);

    public abstract void setExecutingInitSql(boolean var1);

    public abstract void setExecutingInitMongo(boolean var1);

    public abstract void setExecutingAction(boolean var1);

    public abstract BootTimeInfoDto getBootTimeInfoDto();

    protected BootTimeInfoDto getBootTimeInfoDto(BootTimeObjectiveInfo info) {
        if (info == null) {
            return null;
        }
        BootTimeInfoDto infoDto = new BootTimeInfoDto();
        infoDto.targets = info.getObjectiveCoverageAtSutBootTime().entrySet().stream().map(e -> new TargetInfoDto((Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
                this.descriptiveId = (String)this.val$e.getKey();
                this.value = (Double)this.val$e.getValue();
            }
        }).collect(Collectors.toList());
        infoDto.hostnameResolutionInfoDtos = info.getHostnameInfos().stream().map(h -> new HostnameResolutionInfoDto(h.getHostname(), h.getResolvedAddress())).collect(Collectors.toList());
        infoDto.externalServicesDto = info.getExternalServiceInfo().stream().map(e -> new ExternalServiceInfoDto(e.getProtocol(), e.getHostname(), e.getRemotePort())).collect(Collectors.toList());
        return infoDto;
    }

    public abstract void getJvmDtoSchema(List<String> var1);

    private void expandMockObjectIfNeeded(RPCActionDto dto, ActionResponseDto responseDto) {
        AtomicBoolean anyUpdate = new AtomicBoolean(false);
        InterfaceSchema schema = this.rpcInterfaceSchema.get(dto.interfaceId);
        if (dto.mockDatabaseDtos != null && !dto.mockDatabaseDtos.isEmpty()) {
            Stream<MockDatabaseDto> dbstream = dto.mockDatabaseDtos.stream().filter(s -> s.responseFullTypeWithGeneric == null);
            dbstream.forEach(s -> anyUpdate.set(RPCEndpointsBuilder.buildDbExternalServiceResponse(schema, s, schema.getRpcType()) != null));
        }
        if (dto.mockRPCExternalServiceDtos != null && !dto.mockRPCExternalServiceDtos.isEmpty()) {
            Stream<MockRPCExternalServiceDto> exstream = dto.mockRPCExternalServiceDtos.stream().filter(s -> s.responseFullTypesWithGeneric == null);
            exstream.forEach(s -> anyUpdate.set(RPCEndpointsBuilder.buildExternalServiceResponse(schema, s, schema.getRpcType()) != null));
        }
        if (anyUpdate.get()) {
            ExpandRPCInfoDto expand = new ExpandRPCInfoDto();
            expand.schemaDto = schema.getDto();
            expand.expandActionDto = dto.copy();
            responseDto.expandInfo = expand;
        }
    }

    private void extractTypesAndRelated(Map<String, NamedTypedValue> all, List<String> typesToExtract, Map<String, ParamDto> results) {
        for (String type : typesToExtract) {
            this.extractTypeAndRelated(all, type, results);
        }
    }

    private void extractTypeAndRelated(Map<String, NamedTypedValue> all, String typeName, Map<String, ParamDto> results) {
        if (results.containsKey(typeName)) {
            return;
        }
        NamedTypedValue type = all.get(typeName);
        if (type != null) {
            results.put(typeName, type.getDto());
            List<String> referenceTypes = type.referenceTypes();
            if (referenceTypes != null && !referenceTypes.isEmpty()) {
                for (String refType : referenceTypes) {
                    this.extractTypeAndRelated(all, refType, results);
                }
            }
        }
    }

    public abstract String getExecutableFullPath();

    protected UnitsInfoDto getUnitsInfoDto(UnitsInfoRecorder recorder) {
        if (recorder == null) {
            return null;
        }
        UnitsInfoDto dto = new UnitsInfoDto();
        dto.numberOfBranches = recorder.getNumberOfBranches();
        dto.numberOfLines = recorder.getNumberOfLines();
        dto.numberOfReplacedMethodsInSut = recorder.getNumberOfReplacedMethodsInSut();
        dto.numberOfReplacedMethodsInThirdParty = recorder.getNumberOfReplacedMethodsInThirdParty();
        dto.numberOfTrackedMethods = recorder.getNumberOfTrackedMethods();
        dto.unitNames = recorder.getUnitNames();
        dto.parsedDtos = recorder.getParsedDtos();
        dto.extractedSpecifiedDtos = recorder.getExtractedSpecifiedDtos();
        dto.numberOfInstrumentedNumberComparisons = recorder.getNumberOfInstrumentedNumberComparisons();
        dto.extraDatabaseConstraintsDtos = recorder.getJpaConstraints().stream().map(c -> {
            ElementConstraintsDto ec = new ElementConstraintsDto();
            ec.isNullable = c.getNullable();
            ec.isOptional = c.getOptional();
            ec.maxValue = c.getMaxValue();
            ec.minValue = c.getMinValue();
            ec.isNotBlank = c.getNotBlank();
            ec.isEmail = c.getIsEmail();
            ec.decimalMinValue = c.getDecimalMinValue();
            ec.decimalMaxValue = c.getDecimalMaxValue();
            ec.isNegative = c.getIsNegative();
            ec.isNegativeOrZero = c.getIsNegativeOrZero();
            ec.isPositive = c.getIsPositive();
            ec.isPositiveOrZero = c.getIsPositiveOrZero();
            ec.isFuture = c.getIsFuture();
            ec.isFutureOrPresent = c.getIsFutureOrPresent();
            ec.isPast = c.getIsPast();
            ec.isPastOrPresent = c.getIsPastOrPresent();
            ec.isAlwaysNull = c.getIsAlwaysNull();
            ec.patternRegExp = c.getPatternRegExp();
            ec.sizeMin = c.getSizeMin();
            ec.sizeMax = c.getSizeMax();
            ec.digitsFraction = c.getDigitsFraction();
            ec.digitsInteger = c.getDigitsInteger();
            ec.enumValuesAsStrings = c.getEnumValuesAsStrings() == null ? null : new ArrayList<String>(c.getEnumValuesAsStrings());
            ExtraConstraintsDto jpa = new ExtraConstraintsDto();
            jpa.tableName = c.getTableName();
            jpa.columnName = c.getColumnName();
            jpa.constraints = ec;
            return jpa;
        }).collect(Collectors.toList());
        return dto;
    }

    @Override
    public Object getRPCClient(String interfaceName) {
        if (!(this.getProblemInfo() instanceof RPCProblem)) {
            throw new RuntimeException("ERROR: the problem should be RPC but it is " + this.getProblemInfo().getClass().getSimpleName());
        }
        Object client = ((RPCProblem)this.getProblemInfo()).getClient(interfaceName);
        if (client == null) {
            throw new RuntimeException("ERROR: cannot find any client with the name :" + interfaceName);
        }
        return client;
    }

    @Override
    public CustomizedCallResultCode categorizeBasedOnResponse(Object response) {
        return null;
    }

    @Override
    public List<CustomizedRequestValueDto> getCustomizedValueInRequests() {
        return null;
    }

    @Override
    public List<CustomizedNotNullAnnotationForRPCDto> specifyCustomizedNotNullAnnotation() {
        return null;
    }

    @Override
    public List<SeededRPCTestDto> seedRPCTests() {
        return null;
    }

    @Override
    public boolean customizeRPCTestOutput(List<MockRPCExternalServiceDto> externalServiceDtos, List<String> sqlInsertions, List<EvaluatedRPCActionDto> actions) {
        return false;
    }

    @Override
    public boolean customizeMockingRPCExternalService(List<MockRPCExternalServiceDto> externalServiceDtos, boolean enabled) {
        return false;
    }

    @Override
    public boolean customizeMockingDatabase(List<MockDatabaseDto> databaseDtos, boolean enabled) {
        return false;
    }

    @Override
    public void resetDatabase(List<String> tablesToClean) {
        if (this.getDbSpecifications() != null && !this.getDbSpecifications().isEmpty()) {
            this.getDbSpecifications().forEach(spec -> {
                if (spec == null || spec.connection == null || !spec.employSmartDbClean) {
                    return;
                }
                if (tablesToClean == null) {
                    DbCleaner.clearDatabase(spec.connection, null, null, null, spec.dbType);
                    try {
                        this.reAddAllInitSql();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Fail to process all specified initSqlScript " + e);
                    }
                    return;
                }
                if (tablesToClean.isEmpty()) {
                    return;
                }
                if (spec.schemaNames == null || spec.schemaNames.isEmpty()) {
                    DbCleaner.clearDatabase(spec.connection, null, null, tablesToClean, spec.dbType);
                } else {
                    spec.schemaNames.forEach(sp -> DbCleaner.clearDatabase(spec.connection, sp, null, tablesToClean, spec.dbType));
                }
                try {
                    this.handleInitSqlInDbClean((Collection<String>)tablesToClean, (DbSpecification)spec);
                }
                catch (SQLException e) {
                    throw new RuntimeException("Fail to execute the specified initSqlScript " + e);
                }
            });
        }
    }

    public String packagesToSkipInstrumentation() {
        return null;
    }

    @Override
    public final boolean resetCustomizedMethodForMockObject() {
        if (this.getProblemInfo() instanceof RPCProblem) {
            boolean ok = this.mockRPCExternalServicesWithCustomizedHandling(null, false);
            ok = ok && this.mockDatabasesWithCustomizedHandling(null, false);
            return ok;
        }
        return false;
    }

    @Override
    public final boolean mockRPCExternalServicesWithCustomizedHandling(String externalServiceDtos, boolean enabled) {
        List<MockRPCExternalServiceDto> exDto = null;
        try {
            if (externalServiceDtos != null && !externalServiceDtos.isEmpty()) {
                exDto = this.objectMapper.readValue(externalServiceDtos, new TypeReference<List<MockRPCExternalServiceDto>>(){});
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Fail to handle the given external service dto with the info:", e);
        }
        return this.customizeMockingRPCExternalService(exDto, enabled);
    }

    @Override
    public boolean mockDatabasesWithCustomizedHandling(String mockDatabaseObjectDtos, boolean enabled) {
        List<MockDatabaseDto> mockDbObject = null;
        try {
            if (mockDatabaseObjectDtos != null && !mockDatabaseObjectDtos.isEmpty()) {
                mockDbObject = this.objectMapper.readValue(mockDatabaseObjectDtos, new TypeReference<List<MockDatabaseDto>>(){});
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Fail to handle the given mock object for database with the info:", e);
        }
        return this.customizeMockingDatabase(mockDbObject, enabled);
    }

    public final String readFileAsStringFromTestResource(String fileName) {
        return new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(fileName)))).lines().collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public Map<Class, Integer> getExceptionImportanceLevels() {
        return null;
    }
}

