/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.mongo.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.database.operations.MongoInsertionDto;
import org.evomaster.client.java.controller.mongo.dsl.MongoSequenceDsl;
import org.evomaster.client.java.controller.mongo.dsl.MongoStatementDsl;

public class MongoDsl
implements MongoSequenceDsl,
MongoStatementDsl {
    private List<MongoInsertionDto> list = new ArrayList<MongoInsertionDto>();
    private final List<MongoInsertionDto> previousInsertionDtos = new ArrayList<MongoInsertionDto>();

    private MongoDsl() {
    }

    private MongoDsl(List<MongoInsertionDto> ... previous) {
        if (previous != null && previous.length > 0) {
            Arrays.stream(previous).forEach(this.previousInsertionDtos::addAll);
        }
    }

    public static MongoSequenceDsl mongo() {
        return new MongoDsl();
    }

    public static MongoSequenceDsl mongo(List<MongoInsertionDto> ... previous) {
        return new MongoDsl(previous);
    }

    @Override
    public MongoStatementDsl insertInto(String databaseName, String collectionName) {
        this.checkDsl();
        if (databaseName == null || databaseName.isEmpty()) {
            throw new IllegalArgumentException("Unspecified database");
        }
        if (collectionName == null || collectionName.isEmpty()) {
            throw new IllegalArgumentException("Unspecified collection");
        }
        MongoInsertionDto dto = new MongoInsertionDto();
        dto.databaseName = databaseName;
        dto.collectionName = collectionName;
        this.list.add(dto);
        return this;
    }

    @Override
    public MongoStatementDsl d(String printableValue) {
        this.checkDsl();
        this.current().data = printableValue;
        return this;
    }

    @Override
    public MongoSequenceDsl and() {
        return this;
    }

    @Override
    public List<MongoInsertionDto> dtos() {
        List<MongoInsertionDto> tmp = this.list;
        this.list = null;
        return tmp;
    }

    private MongoInsertionDto current() {
        return this.list.get(this.list.size() - 1);
    }

    private void checkDsl() {
        if (this.list == null) {
            throw new IllegalStateException("DTO was already built for this object");
        }
    }
}

