/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.evomaster.client.java.controller.problem.rpc.AssertionsUtil;

public class CodeJavaOrKotlinGenerator {
    private static final String NULL_EXP = "null";
    private static final String GET_CLIENT_METHOD = "getRPCClient";
    private static final String KOTLIN_DECLARATION_VARIABLE = "var";
    private static final String KOTLIN_DECLARATION_VARIABLE_NULLABLE = "?";
    private static final String KOTLIN_NON_NULL_ASSERTED = "!!";
    private static final String JAVA_LANG = "java.lang.";
    private static final String KOTLIN_DEFAULT = "kotlin.";

    public static String handleClassNameWithGeneric(String fullName, List<String> genericTypes) {
        if (genericTypes == null || genericTypes.isEmpty()) {
            return fullName;
        }
        return String.format("%s<%s>", fullName, String.join((CharSequence)", ", CodeJavaOrKotlinGenerator.formatBasicTypes(genericTypes)));
    }

    private static List<String> formatBasicTypes(List<String> types) {
        return types.stream().map(CodeJavaOrKotlinGenerator::formateBasicType).collect(Collectors.toList());
    }

    private static String formateBasicType(String type) {
        if (!type.startsWith(JAVA_LANG) && !type.startsWith(KOTLIN_DEFAULT)) {
            return type;
        }
        String[] pars = type.split("\\.");
        return pars[pars.length - 1];
    }

    public static String handleEscapeCharInString(String orgValue, boolean isJava) {
        StringBuilder sb = new StringBuilder();
        block11: for (char c : orgValue.toCharArray()) {
            switch (c) {
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '$': {
                    if (!isJava) {
                        sb.append("\\$");
                        continue block11;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String typeNameOfArrayOrCollection(String collectionType, boolean isArray, String genericType, boolean isJava) {
        if (isArray) {
            if (isJava) {
                return String.format("%s[]", genericType);
            }
            return String.format("%s<%s>", collectionType, genericType);
        }
        return String.format("%s<%s>", collectionType, genericType);
    }

    public static String enumValue(String enumTypeName, String itemName) {
        return String.format("%s.%s", CodeJavaOrKotlinGenerator.handleNestedSymbolInTypeName(enumTypeName), itemName);
    }

    public static String oneLineInstance(boolean isDeclaration, boolean doesIncludeName, String fullName, String varName, String value, boolean isJava, boolean isNullable) {
        return CodeJavaOrKotlinGenerator.oneLineInstance(isDeclaration, doesIncludeName, fullName, varName, value, false, isJava, isNullable);
    }

    public static String oneLineInstance(boolean isDeclaration, boolean doesIncludeName, String fullName, String varName, String value, Boolean isPrimitive, boolean isJava, boolean isNullable) {
        StringBuilder sb = new StringBuilder();
        if (isDeclaration) {
            if (isJava) {
                sb.append(CodeJavaOrKotlinGenerator.handleNestedSymbolInTypeName(fullName));
            } else {
                sb.append(KOTLIN_DECLARATION_VARIABLE);
            }
            sb.append(" ");
        }
        if (doesIncludeName) {
            sb.append(varName);
            if (!isJava && isDeclaration) {
                String afterType = "";
                if (isNullable) {
                    afterType = KOTLIN_DECLARATION_VARIABLE_NULLABLE;
                }
                if (fullName != null) {
                    sb.append(String.format(": %s%s", CodeJavaOrKotlinGenerator.handleNestedSymbolInTypeName(fullName), afterType));
                }
            }
        }
        String stringValue = "";
        if (!isPrimitive.booleanValue() && (isJava || isNullable)) {
            stringValue = NULL_EXP;
        }
        if (value != null) {
            stringValue = value;
        }
        if (stringValue.length() > 0) {
            sb.append(" = ").append(stringValue);
        }
        sb.append(CodeJavaOrKotlinGenerator.getStatementLast(isJava));
        return sb.toString();
    }

    public static String oneLineSetterInstance(String setterMethodName, String fullName, String varName, String value, boolean isJava, boolean isNullable) {
        String stringValue = NULL_EXP;
        if (value != null) {
            stringValue = CodeJavaOrKotlinGenerator.castToType(fullName, value, isJava);
        }
        return String.format("%s%s.%s(%s)%s", varName, CodeJavaOrKotlinGenerator.variableNullableMark(isJava, isNullable), setterMethodName, stringValue, CodeJavaOrKotlinGenerator.getStatementLast(isJava));
    }

    public static String setInstanceObject(String fullName, String varName, boolean isJava) {
        return String.format("%s = %s%s", varName, CodeJavaOrKotlinGenerator.newObject(fullName, isJava), CodeJavaOrKotlinGenerator.getStatementLast(isJava));
    }

    public static String getStatementLast(boolean isJava) {
        if (isJava) {
            return ";";
        }
        return "";
    }

    public static String newBuilderProto3(String fullName, String varBuilderName, boolean isJava) {
        String dec = String.format("%s.Builder", fullName);
        String afterVar = "";
        if (!isJava) {
            dec = KOTLIN_DECLARATION_VARIABLE;
            afterVar = String.format(":%s%s", String.format("%s.Builder", fullName), KOTLIN_DECLARATION_VARIABLE_NULLABLE);
        }
        return String.format("%s %s%s = %s.newBuilder()%s", dec, varBuilderName, afterVar, fullName, CodeJavaOrKotlinGenerator.getStatementLast(isJava));
    }

    private static String variableNullableMark(boolean isJava, boolean isNullable) {
        if (isJava || !isNullable) {
            return "";
        }
        return KOTLIN_DECLARATION_VARIABLE_NULLABLE;
    }

    private static String variableNonNullAssertedMark(boolean isJava, boolean isNullable) {
        if (isJava || !isNullable) {
            return "";
        }
        return KOTLIN_NON_NULL_ASSERTED;
    }

    public static String setInstance(String varName, String instance, boolean isJava) {
        return String.format("%s = %s%s", varName, instance, CodeJavaOrKotlinGenerator.getStatementLast(isJava));
    }

    public static String setInstance(boolean includeVarName, String varName, String instance, boolean isJava) {
        if (includeVarName) {
            return String.format("%s = %s%s", varName, instance, CodeJavaOrKotlinGenerator.getStatementLast(isJava));
        }
        return instance + CodeJavaOrKotlinGenerator.getStatementLast(isJava);
    }

    private static String newObject(String fullName, boolean isJava) {
        return CodeJavaOrKotlinGenerator.newObjectConsParams(fullName, "", isJava);
    }

    public static String newObjectConsParams(String fullName, String params, boolean isJava) {
        if (isJava) {
            return String.format("new %s(%s)", CodeJavaOrKotlinGenerator.handleNestedSymbolInTypeName(fullName), params);
        }
        return String.format("%s(%s)", CodeJavaOrKotlinGenerator.handleNestedSymbolInTypeName(fullName), params);
    }

    public static String newArray(String fullName, int length, boolean isJava) {
        if (isJava) {
            return String.format("new %s[%d]", fullName, length);
        }
        return String.format("Array<%s>(%d)", fullName, length);
    }

    public static String newSet(boolean isJava, String genericType) {
        if (!isJava) {
            return String.format("mutableSetOf<%s>()", genericType);
        }
        return String.format("new %s<>()", HashSet.class.getName());
    }

    public static String newMap(boolean isJava, String keyGenericType, String valueGenericType) {
        if (!isJava) {
            return String.format("mutableMapOf<%s, %s>()", keyGenericType, valueGenericType);
        }
        return String.format("new %s<>()", HashMap.class.getName());
    }

    public static String newList(boolean isJava, String genericType) {
        if (!isJava) {
            return String.format("mutableListOf<%s>()", genericType);
        }
        return String.format("new %s<>()", ArrayList.class.getName());
    }

    public static String getIndent(int indent) {
        return String.join((CharSequence)"", Collections.nCopies(indent, " "));
    }

    public static List<String> getStringListWithIndent(List<String> codes, int indent) {
        codes.replaceAll(s -> CodeJavaOrKotlinGenerator.getIndent(indent) + s);
        return codes;
    }

    public static List<String> addCode(List<String> codes, String code, int indent) {
        codes.add(CodeJavaOrKotlinGenerator.getIndent(indent) + code);
        return codes;
    }

    public static String codeBlockStart(boolean isJava) {
        if (isJava) {
            return "{";
        }
        return "run {";
    }

    public static String codeBlockEnd(boolean isJava) {
        return "}";
    }

    public static List<String> addComment(List<String> codes, String comment, int indent) {
        codes.add(CodeJavaOrKotlinGenerator.getIndent(indent) + "// " + comment);
        return codes;
    }

    public static String castToType(String typeName, String objCode, boolean isJava) {
        if (typeName == null) {
            return objCode;
        }
        if (isJava) {
            return String.format("((%s)(%s))", CodeJavaOrKotlinGenerator.handleNestedSymbolInTypeName(typeName), objCode);
        }
        return String.format("%s as? %s?", objCode, CodeJavaOrKotlinGenerator.handleNestedSymbolInTypeName(typeName));
    }

    private static String handleNestedSymbolInTypeName(String typeName) {
        return typeName.replaceAll("\\$", "\\.");
    }

    public static String getGetClientMethod(String controllerVarName, String interfaceName) {
        return String.format("%s(%s)", controllerVarName + "." + GET_CLIENT_METHOD, interfaceName);
    }

    public static String methodInvocation(String obj, String methodName, String params, boolean isJava, boolean objIsNullable, boolean isNotNullAsserted) {
        if (obj == null) {
            return String.format("%s(%s)", methodName, params);
        }
        String mark = CodeJavaOrKotlinGenerator.variableNullableMark(isJava, objIsNullable);
        if (isNotNullAsserted) {
            mark = CodeJavaOrKotlinGenerator.variableNonNullAssertedMark(isJava, objIsNullable);
        }
        return String.format("%s%s.%s(%s)", obj, mark, methodName, params);
    }

    public static String fieldAccess(String obj, String filedName, boolean isJava, boolean objIsNullable, boolean isNonNullAsserted) {
        if (obj == null) {
            return filedName;
        }
        String mark = CodeJavaOrKotlinGenerator.variableNullableMark(isJava, objIsNullable);
        if (isNonNullAsserted) {
            mark = CodeJavaOrKotlinGenerator.variableNonNullAssertedMark(isJava, objIsNullable);
        }
        return String.format("%s%s.%s", obj, mark, filedName);
    }

    public static String junitAssertEquals(String expectedValue, String variableName, boolean isJava) {
        String assertionScript = String.format("assertEquals(%s, %s)", expectedValue, variableName) + CodeJavaOrKotlinGenerator.getStatementLast(isJava);
        if (AssertionsUtil.getAssertionsWithComment(assertionScript)) {
            return "//" + assertionScript;
        }
        if (expectedValue.length() > 10) {
            return "//" + assertionScript;
        }
        return assertionScript;
    }

    public static String junitAssertNull(String variableName, boolean isJava) {
        String assertionScript = String.format("assertNull(%s)", variableName) + CodeJavaOrKotlinGenerator.getStatementLast(isJava);
        if (AssertionsUtil.getAssertionsWithComment(assertionScript)) {
            return "//" + assertionScript;
        }
        return assertionScript;
    }

    public static String withSizeInAssertion(String variableName, boolean isJava, boolean isNullable) {
        String methodName = "size()";
        if (!isJava) {
            methodName = "size";
        }
        return String.format("%s%s.%s", variableName, CodeJavaOrKotlinGenerator.variableNonNullAssertedMark(isJava, isNullable), methodName);
    }

    public static String withLengthInAssertion(String variableName, boolean isJava, boolean isNullable) {
        return String.format("%s%s.length", variableName, CodeJavaOrKotlinGenerator.variableNonNullAssertedMark(isJava, isNullable));
    }

    public static String junitAssertNumbersMatch(String expectedValue, String variableName, boolean isJava) {
        String assertionScript = String.format("assertTrue(numbersMatch(%s, %s))", expectedValue, variableName) + CodeJavaOrKotlinGenerator.getStatementLast(isJava);
        if (AssertionsUtil.getAssertionsWithComment(assertionScript)) {
            return "//" + assertionScript;
        }
        return assertionScript;
    }

    public static String handleVariableName(String original) {
        return original.replaceAll("\\.", "_");
    }

    public static List<Integer> randomNInt(int max, int n) {
        if (n >= max) {
            throw new IllegalStateException("count should be less than max");
        }
        List candidates = IntStream.range(0, max).boxed().collect(Collectors.toList());
        Collections.shuffle(candidates);
        return candidates.subList(0, n);
    }
}

