/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.evomaster.client.java.controller.problem.rpc.JavaXConstraintSupportType;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigDecimalParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigIntegerParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BooleanParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.CollectionParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.MapParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NumericConstraintBase;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.StringParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.utils.SimpleLogger;

public class JavaXConstraintHandler {
    public static void handleParam(NamedTypedValue namedTypedValue, Annotation annotation) {
        Class<? extends Annotation> cons = annotation.annotationType();
        JavaXConstraintSupportType supportType = JavaXConstraintSupportType.getSupportType(cons.getSimpleName());
        if (supportType == null) {
            SimpleLogger.recordErrorMessage("Warning: Not handle constraints with a specified annotation:" + cons.getName());
            return;
        }
        boolean solved = false;
        switch (supportType) {
            case NOT_NULL: {
                solved = JavaXConstraintHandler.handleNotNull(namedTypedValue);
                break;
            }
            case NOT_EMPTY: {
                solved = JavaXConstraintHandler.handleNotEmpty(namedTypedValue);
                break;
            }
            case NOT_BLANK: {
                solved = JavaXConstraintHandler.handleNotBlank(namedTypedValue);
                break;
            }
            case SIZE: {
                solved = JavaXConstraintHandler.handleSize(namedTypedValue, annotation);
                break;
            }
            case PATTERN: {
                solved = JavaXConstraintHandler.handlePattern(namedTypedValue, annotation);
                break;
            }
            case DECIMAL_MAX: 
            case MAX: {
                solved = JavaXConstraintHandler.handleMax(namedTypedValue, annotation, supportType);
                break;
            }
            case DECIMAL_MIN: 
            case MIN: {
                solved = JavaXConstraintHandler.handleMin(namedTypedValue, annotation, supportType);
                break;
            }
            case DIGITS: {
                solved = JavaXConstraintHandler.handleDigits(namedTypedValue, annotation);
                break;
            }
            case POSITIVE: 
            case POSITIVEORZERO: 
            case NEGATIVE: 
            case NEGATIVEORZERO: {
                solved = JavaXConstraintHandler.handlePositiveOrNegative(namedTypedValue, supportType);
                break;
            }
            case ASSERTFALSE: 
            case ASSERTTRUE: {
                solved = JavaXConstraintHandler.handleAssertFalseOrTrue(namedTypedValue, supportType);
                break;
            }
            case NULL: {
                solved = JavaXConstraintHandler.handleNull(namedTypedValue);
                break;
            }
            default: {
                SimpleLogger.recordErrorMessage("Warning: Not handle " + supportType.annotation);
            }
        }
        if (!solved) {
            SimpleLogger.recordErrorMessage("Warning: Do not solve class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName() + " with its constraint " + cons.getName());
        }
    }

    private static boolean handleNotNull(NamedTypedValue namedTypedValue) {
        namedTypedValue.setNullable(false);
        return true;
    }

    private static boolean handleNotEmpty(NamedTypedValue namedTypedValue) {
        namedTypedValue.setNullable(false);
        if (namedTypedValue instanceof CollectionParam) {
            ((CollectionParam)namedTypedValue).setMinSize(1);
        } else if (namedTypedValue instanceof MapParam) {
            ((MapParam)namedTypedValue).setMinSize(1);
        } else if (namedTypedValue instanceof StringParam) {
            ((StringParam)namedTypedValue).setMinSize(1);
        } else {
            SimpleLogger.recordErrorMessage("Warning: Do not solve class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName() + " with its NotEmpty");
            return false;
        }
        return true;
    }

    private static boolean handleNotBlank(NamedTypedValue namedTypedValue) {
        namedTypedValue.setNullable(false);
        if (namedTypedValue instanceof StringParam) {
            ((StringParam)namedTypedValue).setMinSize(1);
        }
        if (!(namedTypedValue instanceof PrimitiveOrWrapperParam)) {
            SimpleLogger.recordErrorMessage("Warning: Do not solve class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName() + " with its NotBlank");
            return false;
        }
        namedTypedValue.setNullable(false);
        return true;
    }

    private static boolean handleSize(NamedTypedValue namedTypedValue, Annotation annotation) {
        Integer[] size = new Integer[2];
        try {
            size[0] = (Integer)annotation.annotationType().getDeclaredMethod("min", new Class[0]).invoke((Object)annotation, new Object[0]);
            size[1] = (Integer)annotation.annotationType().getDeclaredMethod("max", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("ERROR: fail to process Size " + e.getMessage());
        }
        if (size[0] == null) {
            SimpleLogger.recordErrorMessage("Warning: Size min is null");
            return false;
        }
        if (size[1] == null) {
            SimpleLogger.recordErrorMessage("Warning: Size max is null");
            return false;
        }
        if (namedTypedValue instanceof CollectionParam) {
            ((CollectionParam)namedTypedValue).setMinSize(size[0]);
            ((CollectionParam)namedTypedValue).setMaxSize(size[1]);
        } else if (namedTypedValue instanceof MapParam) {
            ((MapParam)namedTypedValue).setMinSize(size[0]);
            ((MapParam)namedTypedValue).setMaxSize(size[1]);
        } else if (namedTypedValue instanceof StringParam) {
            ((StringParam)namedTypedValue).setMinSize(size[0]);
            ((StringParam)namedTypedValue).setMaxSize(size[1]);
        } else {
            SimpleLogger.recordErrorMessage("Warning: Do not solve class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName() + " with its Size");
            return false;
        }
        return true;
    }

    private static boolean handlePattern(NamedTypedValue namedTypedValue, Annotation annotation) {
        String pattern = null;
        try {
            pattern = (String)annotation.annotationType().getDeclaredMethod("regexp", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("ERROR: fail to process regexp " + e.getMessage());
        }
        if (pattern == null) {
            SimpleLogger.recordErrorMessage("Warning: Pattern regexp is null for the param:" + namedTypedValue.getName());
            return false;
        }
        if (!(namedTypedValue instanceof StringParam)) {
            SimpleLogger.recordErrorMessage("Warning: Do not solve class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName() + " with its Size");
            return false;
        }
        ((StringParam)namedTypedValue).setPattern(pattern);
        return true;
    }

    private static boolean handleMax(NamedTypedValue namedTypedValue, Annotation annotation, JavaXConstraintSupportType supportType) {
        String maxStr = null;
        Boolean inclusive = true;
        try {
            if (supportType == JavaXConstraintSupportType.DECIMAL_MAX) {
                maxStr = (String)annotation.annotationType().getDeclaredMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                inclusive = (Boolean)annotation.annotationType().getDeclaredMethod("inclusive", new Class[0]).invoke((Object)annotation, new Object[0]);
            } else {
                maxStr = ((Long)annotation.annotationType().getDeclaredMethod("value", new Class[0]).invoke((Object)annotation, new Object[0])).toString();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("ERROR: fail to process max " + e.getMessage());
        }
        if (maxStr == null) {
            SimpleLogger.recordErrorMessage("Warning: Max value is null");
            return false;
        }
        return JavaXConstraintHandler.setMax(namedTypedValue, maxStr, inclusive);
    }

    private static boolean handleMin(NamedTypedValue namedTypedValue, Annotation annotation, JavaXConstraintSupportType supportType) {
        String minStr = null;
        Boolean inclusive = true;
        try {
            if (supportType == JavaXConstraintSupportType.DECIMAL_MIN) {
                minStr = (String)annotation.annotationType().getDeclaredMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                inclusive = (Boolean)annotation.annotationType().getDeclaredMethod("inclusive", new Class[0]).invoke((Object)annotation, new Object[0]);
            } else {
                minStr = ((Long)annotation.annotationType().getDeclaredMethod("value", new Class[0]).invoke((Object)annotation, new Object[0])).toString();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("ERROR: fail to process min " + e.getMessage());
        }
        if (minStr == null) {
            SimpleLogger.recordErrorMessage("Warning: Min value is null");
            return false;
        }
        return JavaXConstraintHandler.setMin(namedTypedValue, minStr, inclusive);
    }

    private static boolean setMin(NamedTypedValue namedTypedValue, String min, boolean inclusive) {
        if (!(namedTypedValue instanceof NumericConstraintBase)) {
            SimpleLogger.recordErrorMessage("Warning: Can not set MinValue for the class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName());
        }
        if (namedTypedValue instanceof PrimitiveOrWrapperParam) {
            ((PrimitiveOrWrapperParam)namedTypedValue).setMin(new BigDecimal(min));
            ((PrimitiveOrWrapperParam)namedTypedValue).setMinInclusive(inclusive);
        } else if (namedTypedValue instanceof StringParam) {
            ((StringParam)namedTypedValue).setMin(new BigDecimal(min));
            ((StringParam)namedTypedValue).setMinInclusive(inclusive);
        } else if (namedTypedValue instanceof BigIntegerParam) {
            ((BigIntegerParam)namedTypedValue).setMin(new BigInteger(min));
            ((BigIntegerParam)namedTypedValue).setMinInclusive(inclusive);
        } else if (namedTypedValue instanceof BigDecimalParam) {
            ((BigDecimalParam)namedTypedValue).setMin(new BigDecimal(min));
            ((BigDecimalParam)namedTypedValue).setMinInclusive(inclusive);
        } else {
            SimpleLogger.recordErrorMessage("Warning: Can not solve constraints by setting Min value for the class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName());
            return false;
        }
        return true;
    }

    private static boolean setMax(NamedTypedValue namedTypedValue, String max, boolean inclusive) {
        if (!(namedTypedValue instanceof NumericConstraintBase)) {
            SimpleLogger.recordErrorMessage("Warning: Can not set MaxValue for the class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName());
        }
        if (namedTypedValue instanceof PrimitiveOrWrapperParam) {
            ((PrimitiveOrWrapperParam)namedTypedValue).setMax(new BigDecimal(max));
            ((PrimitiveOrWrapperParam)namedTypedValue).setMaxInclusive(inclusive);
        } else if (namedTypedValue instanceof StringParam) {
            ((StringParam)namedTypedValue).setMax(new BigDecimal(max));
            ((StringParam)namedTypedValue).setMaxInclusive(inclusive);
        } else if (namedTypedValue instanceof BigIntegerParam) {
            ((BigIntegerParam)namedTypedValue).setMax(new BigInteger(max));
            ((BigIntegerParam)namedTypedValue).setMaxInclusive(inclusive);
        } else if (namedTypedValue instanceof BigDecimalParam) {
            ((BigDecimalParam)namedTypedValue).setMax(new BigDecimal(max));
            ((BigDecimalParam)namedTypedValue).setMaxInclusive(inclusive);
        } else {
            SimpleLogger.recordErrorMessage("Warning: Can not solve constraints by setting Max value for the class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName());
            return false;
        }
        return true;
    }

    private static boolean handleDigits(NamedTypedValue namedTypedValue, Annotation annotation) {
        if (namedTypedValue instanceof BigDecimalParam || namedTypedValue instanceof BigIntegerParam || namedTypedValue instanceof StringParam || namedTypedValue instanceof PrimitiveOrWrapperParam && ((PrimitiveOrWrapperType)namedTypedValue.getType()).isIntegralNumber()) {
            try {
                int dInteger = (Integer)annotation.annotationType().getDeclaredMethod("integer", new Class[0]).invoke((Object)annotation, new Object[0]);
                int dFraction = (Integer)annotation.annotationType().getDeclaredMethod("fraction", new Class[0]).invoke((Object)annotation, new Object[0]);
                if ((namedTypedValue instanceof BigIntegerParam || namedTypedValue instanceof PrimitiveOrWrapperParam) && dFraction > 0) {
                    SimpleLogger.recordErrorMessage("Warning: fraction should be 0 for integral number, param name: " + namedTypedValue.getName());
                    dFraction = 0;
                }
                ((NumericConstraintBase)((Object)namedTypedValue)).setPrecision(dInteger + dFraction);
                ((NumericConstraintBase)((Object)namedTypedValue)).setScale(dFraction);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("ERROR: fail to process Digits ", e);
            }
        } else {
            SimpleLogger.recordErrorMessage("Warning: Do not solve class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName() + " with Digits constraints");
            return false;
        }
        return true;
    }

    private static boolean handlePositiveOrNegative(NamedTypedValue namedTypedValue, JavaXConstraintSupportType supportType) {
        if (namedTypedValue instanceof BigDecimalParam || namedTypedValue instanceof BigIntegerParam || namedTypedValue instanceof PrimitiveOrWrapperParam && ((PrimitiveOrWrapperType)namedTypedValue.getType()).isNumber()) {
            String zero = "0";
            switch (supportType) {
                case POSITIVE: {
                    JavaXConstraintHandler.setMin(namedTypedValue, zero, false);
                    break;
                }
                case POSITIVEORZERO: {
                    JavaXConstraintHandler.setMin(namedTypedValue, zero, true);
                    break;
                }
                case NEGATIVE: {
                    JavaXConstraintHandler.setMax(namedTypedValue, zero, false);
                    break;
                }
                case NEGATIVEORZERO: {
                    JavaXConstraintHandler.setMax(namedTypedValue, zero, true);
                    break;
                }
                default: {
                    throw new IllegalStateException("ERROR: constraint is not handled " + (Object)((Object)supportType));
                }
            }
        } else {
            SimpleLogger.recordErrorMessage("Warning: Do not solve class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName() + " with its Digits");
            return false;
        }
        return true;
    }

    private static boolean handleAssertFalseOrTrue(NamedTypedValue namedTypedValue, JavaXConstraintSupportType supportType) {
        if (supportType != JavaXConstraintSupportType.ASSERTFALSE && supportType != JavaXConstraintSupportType.ASSERTTRUE) {
            throw new IllegalStateException("ERROR: handleAssertFalseOrTrue cannot handle the constraint " + (Object)((Object)supportType));
        }
        if (namedTypedValue instanceof BooleanParam) {
            namedTypedValue.setMutable(false);
            NamedTypedValue defaultValue = namedTypedValue.copyStructure();
            defaultValue.setValue(supportType == JavaXConstraintSupportType.ASSERTTRUE);
            namedTypedValue.setDefaultValue(defaultValue);
            return true;
        }
        SimpleLogger.recordErrorMessage("Warning: Do not solve class " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName() + " with its AssertFalse or AssertTrue");
        return false;
    }

    private static boolean handleNull(NamedTypedValue namedTypedValue) {
        namedTypedValue.setMutable(false);
        namedTypedValue.setDefaultValue(null);
        return true;
    }
}

