/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public class BooleanParam
extends PrimitiveOrWrapperParam<Boolean> {
    private static final String JAVA_PR_METHOD = "booleanValue";
    private static final String KOTLIN_PR_METHOD = "toBoolean";

    public BooleanParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema, JavaDtoSpec spec) {
        super(name, type, fullTypeName, clazz, accessibleSchema, spec);
    }

    public BooleanParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        if (this.getValue() == null) {
            return null;
        }
        return String.valueOf(this.getValue());
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.stringValue = ((Boolean)this.getValue()).toString();
        }
        dto.type.type = ((PrimitiveOrWrapperType)this.getType()).isWrapper ? RPCSupportedDataType.BOOLEAN : RPCSupportedDataType.P_BOOLEAN;
        return dto;
    }

    public BooleanParam copyStructure() {
        return new BooleanParam(this.getName(), (PrimitiveOrWrapperType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnStringValue(String stringValue) {
        try {
            if (stringValue != null) {
                this.setValue(Boolean.parseBoolean(stringValue));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: fail to convert " + stringValue + " as boolean value");
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((Boolean)instance);
    }

    @Override
    public boolean isValidInstance(Object instance) {
        return instance instanceof Boolean;
    }

    @Override
    public String primitiveValueMethod(boolean isJava) {
        if (isJava) {
            return JAVA_PR_METHOD;
        }
        return KOTLIN_PR_METHOD;
    }
}

