/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.ByteBufferType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class ByteBufferParam
extends NamedTypedValue<ByteBufferType, ByteBuffer> {
    public ByteBufferParam(String name, AccessibleSchema accessibleSchema, JavaDtoSpec spec) {
        super(name, new ByteBufferType(spec), accessibleSchema);
    }

    @Override
    public void setValue(byte[] value) {
        ByteBuffer buffer = ByteBuffer.allocate(value.length);
        buffer.put(value);
        this.setValue(buffer);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        return this.getValue();
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.stringValue = new String(((ByteBuffer)this.getValue()).array(), StandardCharsets.UTF_8);
        }
        return dto;
    }

    public ByteBufferParam copyStructure() {
        return new ByteBufferParam(this.getName(), this.accessibleSchema, ((ByteBufferType)this.getType()).spec);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.stringValue != null) {
            this.setValue(dto.stringValue.getBytes());
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((ByteBuffer)instance);
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        if (json == null) {
            return;
        }
        if (!(json instanceof String)) {
            throw new IllegalArgumentException("Cannot set value for ByteBufferParam with the type:" + json.getClass().getName());
        }
        this.setValue(((String)json).getBytes());
    }

    @Override
    public List<String> newInstanceWithJavaOrKotlin(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent, boolean isJava, boolean isVariableNullable) {
        ArrayList<String> codes = new ArrayList<String>();
        String var = CodeJavaOrKotlinGenerator.oneLineInstance(isDeclaration, doesIncludeName, ByteBuffer.class.getName(), variableName, null, isJava, this.isNullable());
        CodeJavaOrKotlinGenerator.addCode(codes, var, indent);
        if (this.getValue() == null) {
            return codes;
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockStart(isJava), indent);
        String varValue = variableName + "_byteArray";
        String byteArray = CodeJavaOrKotlinGenerator.methodInvocation("\"" + new String(((ByteBuffer)this.getValue()).array(), StandardCharsets.UTF_8) + "\"", isJava ? "getBytes" : "toByteArray", StandardCharsets.class.getName() + ".UTF_8", isJava, false, false);
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.oneLineInstance(true, true, isJava ? "byte[]" : "ByteArray", varValue, byteArray, isJava, this.isNullable()), indent + 1);
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.oneLineInstance(false, true, "String", variableName, ByteBuffer.class.getName() + ".allocate(" + CodeJavaOrKotlinGenerator.fieldAccess(varValue, (isJava ? "length" : "size") + ")", isJava, this.isNullable(), true), isJava, this.isNullable()), indent + 1);
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.methodInvocation(variableName, "put", varValue, isJava, this.isNullable(), false) + CodeJavaOrKotlinGenerator.getStatementLast(isJava), indent + 1);
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockEnd(isJava), indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJavaOrKotlin(int indent, String responseVarName, int maxAssertionForDataInCollection, boolean isJava) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaOrKotlinGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaOrKotlinGenerator.junitAssertNull(responseVarName, isJava));
        } else {
            sb.append("// not handle ByteBuffer assertion");
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        return null;
    }

    @Override
    public List<String> referenceTypes() {
        return null;
    }
}

