/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.IntParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.DateType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.LocalDateType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.UtilDateType;

public class DateParam
extends NamedTypedValue<DateType, List<IntParam>> {
    public DateParam(String name, DateType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        return ((DateType)this.getType()).getDateInstance((List)this.getValue());
    }

    public DateParam copyStructure() {
        return new DateParam(this.getName(), (DateType)this.getType(), this.accessibleSchema);
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.innerContent = ((List)this.getValue()).stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
            dto.setNotNullValue();
        } else {
            dto.innerContent = ((DateType)this.getType()).getDateFields().stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        }
        return dto;
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.innerContent != null && !dto.innerContent.isEmpty()) {
            List<IntParam> fields = ((DateType)this.getType()).getDateFields();
            ArrayList<IntParam> values = new ArrayList<IntParam>();
            for (ParamDto p : dto.innerContent) {
                IntParam f = (IntParam)fields.stream().filter(s -> s.sameParam(p)).findFirst().get().copyStructureWithProperties();
                f.setValueBasedOnDto(p);
                values.add(f);
            }
            this.setValue(values);
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        if (instance == null) {
            return;
        }
        this.setValue(((DateType)this.getType()).getIntValues(instance));
    }

    @Override
    public List<String> newInstanceWithJavaOrKotlin(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent, boolean isJava, boolean isVariableNullable) {
        String typeName = ((DateType)this.getType()).getTypeNameForInstanceInJavaOrKotlin(isJava);
        String varName = variableName;
        ArrayList<String> codes = new ArrayList<String>();
        boolean isNull = this.getValue() == null;
        String var = CodeJavaOrKotlinGenerator.oneLineInstance(isDeclaration, doesIncludeName, typeName, varName, null, isJava, this.isNullable());
        CodeJavaOrKotlinGenerator.addCode(codes, var, indent);
        if (isNull) {
            return codes;
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockStart(isJava), indent);
        CodeJavaOrKotlinGenerator.addComment(codes, "Date is " + ((DateType)this.getType()).getDateString((List)this.getValue()), indent + 1);
        String time = ((DateType)this.getType()).getDateLong((List)this.getValue()) + "L";
        if (this.getType() instanceof UtilDateType) {
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.setInstance(varName, CodeJavaOrKotlinGenerator.newObjectConsParams(typeName, time, isJava), isJava), indent + 1);
        } else if (this.getType() instanceof LocalDateType) {
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.setInstance(varName, CodeJavaOrKotlinGenerator.methodInvocation(typeName, "ofEpochDay", time, isJava, false, false), isJava), indent + 1);
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockEnd(isJava), indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJavaOrKotlin(int indent, String responseVarName, int maxAssertionForDataInCollection, boolean isJava) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaOrKotlinGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaOrKotlinGenerator.junitAssertNull(responseVarName, isJava));
        } else {
            sb.append("// runtime value is ");
            sb.append(((DateType)this.getType()).getDateString((List)this.getValue()));
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        return null;
    }

    @Override
    public List<String> referenceTypes() {
        return null;
    }
}

