/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.EnumParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PairParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.StringParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.MapType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PairType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class MapParam
extends NamedTypedValue<MapType, List<PairParam>> {
    private Integer minSize;
    private Integer maxSize;

    public MapParam(String name, MapType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        return ((List)this.getValue()).stream().map(i -> {
            try {
                return new AbstractMap.SimpleEntry<Object, Object>(((NamedTypedValue)((AbstractMap.SimpleEntry)i.getValue()).getKey()).newInstance(), ((NamedTypedValue)((AbstractMap.SimpleEntry)i.getValue()).getValue()).newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("MapParam: could not create new instance for key and value (%s,%s)", ((NamedTypedValue)((AbstractMap.SimpleEntry)i.getValue()).getKey()).toString(), ((NamedTypedValue)((AbstractMap.SimpleEntry)i.getValue()).getValue()).getType()));
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = RPCSupportedDataType.MAP;
        if (this.getValue() != null) {
            dto.innerContent = ((List)this.getValue()).stream().map(s -> s.getDto()).collect(Collectors.toList());
        }
        if (this.minSize != null) {
            dto.minSize = (long)this.minSize;
        }
        if (this.maxSize != null) {
            dto.maxSize = (long)this.maxSize;
        }
        return dto;
    }

    public MapParam copyStructure() {
        return new MapParam(this.getName(), (MapType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.innerContent != null && !dto.innerContent.isEmpty()) {
            PairParam t = ((MapType)this.getType()).getTemplate();
            List values = dto.innerContent.stream().map(s -> {
                PairParam c = (PairParam)t.copyStructureWithProperties();
                c.setValueBasedOnDto((ParamDto)s);
                return c;
            }).collect(Collectors.toList());
            this.setValue(values);
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        if (instance == null) {
            return;
        }
        PairParam t = ((MapType)this.getType()).getTemplate();
        ArrayList<PairParam> values = new ArrayList<PairParam>();
        for (Map.Entry e : ((Map)instance).entrySet()) {
            PairParam copy = (PairParam)t.copyStructureWithProperties();
            copy.setValueBasedOnInstance(e);
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        Object instance = json;
        if (json instanceof String) {
            instance = this.parseValueWithJson((String)json);
        }
        if (instance == null) {
            this.setValue(null);
            return;
        }
        if (!this.isValidInstance(instance)) {
            throw new RuntimeException("cannot parse Map param " + this.getName() + " with the type " + json.getClass().getName());
        }
        PairParam t = ((MapType)this.getType()).getTemplate();
        ArrayList<PairParam> values = new ArrayList<PairParam>();
        for (Map.Entry e : ((Map)instance).entrySet()) {
            PairParam copy = (PairParam)t.copyStructureWithProperties();
            copy.setValueBasedOnInstanceOrJson(e);
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public List<String> newInstanceWithJavaOrKotlin(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent, boolean isJava, boolean isVariableNullable) {
        String fullName = ((MapType)this.getType()).getTypeNameForInstanceInJavaOrKotlin(isJava);
        ArrayList<String> codes = new ArrayList<String>();
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.oneLineInstance(isDeclaration, doesIncludeName, fullName, variableName, null, isJava, this.isNullable()), indent);
        if (this.getValue() == null) {
            return codes;
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockStart(isJava), indent);
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.setInstance(variableName, CodeJavaOrKotlinGenerator.newMap(isJava, ((TypeSchema)((PairType)((MapType)this.getType()).getTemplate().getType()).getFirstTemplate().getType()).getTypeNameForInstanceInJavaOrKotlin(isJava), ((TypeSchema)((PairType)((MapType)this.getType()).getTemplate().getType()).getSecondTemplate().getType()).getTypeNameForInstanceInJavaOrKotlin(isJava)), isJava), indent + 1);
        int index = 0;
        for (PairParam e : (List)this.getValue()) {
            String eKeyVarName = CodeJavaOrKotlinGenerator.handleVariableName(variableName + "_key_" + index);
            if (((AbstractMap.SimpleEntry)e.getValue()).getKey() == null) {
                throw new RuntimeException("key should not been null");
            }
            codes.addAll(((NamedTypedValue)((AbstractMap.SimpleEntry)e.getValue()).getKey()).newInstanceWithJavaOrKotlin(true, true, eKeyVarName, indent + 1, isJava, false));
            String eValueVarName = CodeJavaOrKotlinGenerator.handleVariableName(variableName + "_value_" + index);
            if (((AbstractMap.SimpleEntry)e.getValue()).getValue() == null) {
                throw new RuntimeException("value should not been null");
            }
            codes.addAll(((NamedTypedValue)((AbstractMap.SimpleEntry)e.getValue()).getValue()).newInstanceWithJavaOrKotlin(true, true, eValueVarName, indent + 1, isJava, false));
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.methodInvocation(variableName, "put", eKeyVarName + "," + eValueVarName, isJava, this.isNullable(), false) + CodeJavaOrKotlinGenerator.getStatementLast(isJava), indent + 1);
            ++index;
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockEnd(isJava), indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJavaOrKotlin(int indent, String responseVarName, int maxAssertionForDataInCollection, boolean isJava) {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.getValue() == null) {
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.junitAssertNull(responseVarName, isJava), indent);
            return codes;
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.junitAssertEquals(String.valueOf(((List)this.getValue()).size()), CodeJavaOrKotlinGenerator.withSizeInAssertion(responseVarName, isJava, this.isNullable()), isJava), indent);
        if (maxAssertionForDataInCollection == 0) {
            return codes;
        }
        if (this.doAssertion(((PairType)((MapType)this.getType()).getTemplate().getType()).getFirstTemplate())) {
            List<Object> nvalue = null;
            nvalue = maxAssertionForDataInCollection > 0 && ((List)this.getValue()).size() > maxAssertionForDataInCollection ? CodeJavaOrKotlinGenerator.randomNInt(((List)this.getValue()).size(), maxAssertionForDataInCollection) : IntStream.range(0, ((List)this.getValue()).size()).boxed().collect(Collectors.toList());
            Iterator iterator = nvalue.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                PairParam e = (PairParam)((List)this.getValue()).get(index);
                String key = ((NamedTypedValue)((AbstractMap.SimpleEntry)e.getValue()).getKey()).getValueAsJavaString(isJava);
                if (key == null) {
                    throw new RuntimeException("key is null");
                }
                String eValueVarName = CodeJavaOrKotlinGenerator.methodInvocation(responseVarName, "get", key, isJava, this.isNullable(), true);
                if (((AbstractMap.SimpleEntry)e.getValue()).getValue() == null) {
                    throw new RuntimeException("value should not been null");
                }
                codes.addAll(((NamedTypedValue)((AbstractMap.SimpleEntry)e.getValue()).getValue()).newAssertionWithJavaOrKotlin(indent, eValueVarName, maxAssertionForDataInCollection, isJava));
            }
        } else {
            SimpleLogger.error("ERROR: do not support to generate assertions for Map with key :" + ((TypeSchema)((NamedTypedValue)((AbstractMap.SimpleEntry)((MapType)this.getType()).getTemplate().getValue()).getKey()).getType()).getFullTypeName());
        }
        return codes;
    }

    private boolean doAssertion(NamedTypedValue key) {
        return key instanceof PrimitiveOrWrapperParam || key instanceof EnumParam || key instanceof StringParam;
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        return null;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        if (this.minSize != null && this.minSize >= minSize) {
            return;
        }
        this.minSize = minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void copyProperties(NamedTypedValue copy) {
        super.copyProperties(copy);
        if (copy instanceof MapParam) {
            ((MapParam)copy).setMinSize(this.minSize);
            ((MapParam)copy).setMaxSize(this.maxSize);
        }
    }

    @Override
    public List<String> referenceTypes() {
        ArrayList<String> references = new ArrayList<String>();
        PairParam template = ((MapType)this.getType()).getTemplate();
        List<String> refrefTypes = template.referenceTypes();
        if (refrefTypes != null) {
            references.addAll(refrefTypes);
        }
        if (references.isEmpty()) {
            return null;
        }
        return references;
    }
}

