/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NumericConstraintBase;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.StringType;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class StringParam
extends NamedTypedValue<StringType, String>
implements NumericConstraintBase<BigDecimal> {
    private Integer minSize;
    private Integer maxSize;
    private BigDecimal min;
    private BigDecimal max;
    private String pattern;
    private boolean minInclusive = true;
    private boolean maxInclusive = true;
    private Integer precision;
    private Integer scale;

    public StringParam(String name, StringType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    public StringParam(String name, AccessibleSchema accessibleSchema, JavaDtoSpec spec) {
        super(name, new StringType(spec), accessibleSchema);
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        if (this.minSize != null && this.minSize >= minSize) {
            return;
        }
        this.minSize = minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = this.maxSize != null ? Integer.valueOf(Math.min(this.maxSize, maxSize)) : maxSize;
    }

    @Override
    public BigDecimal getMin() {
        return this.min;
    }

    @Override
    public void setMin(BigDecimal min) {
        if (min == null) {
            return;
        }
        if (this.min == null || this.min.compareTo(min) < 0) {
            this.min = min;
        }
    }

    @Override
    public BigDecimal getMax() {
        return this.max;
    }

    @Override
    public void setMax(BigDecimal max) {
        if (max == null) {
            return;
        }
        if (this.max == null || this.max.compareTo(max) > 0) {
            this.max = max;
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Object newInstance() {
        return this.getValue();
    }

    @Override
    public List<String> referenceTypes() {
        return null;
    }

    public StringParam copyStructure() {
        return new StringParam(this.getName(), (StringType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.stringValue != null) {
            this.setValue(dto.stringValue);
        }
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        if (json == null) {
            return;
        }
        if (json instanceof Number) {
            SimpleLogger.recordErrorMessage("Warning: invalid data type in json for StringParam, attempt to set the value with number value for param " + this.getName());
            this.setValue(json.toString());
        } else {
            if (!(json instanceof String)) {
                throw new IllegalArgumentException("Cannot set value for StringParam " + this.getName() + " with the type:" + json.getClass().getName());
            }
            this.setValue((String)json);
        }
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.stringValue = (String)this.getValue();
        }
        if (this.maxSize != null) {
            dto.maxSize = (long)this.maxSize;
        }
        if (this.minSize != null) {
            dto.minSize = (long)this.minSize;
        }
        if (this.pattern != null) {
            dto.pattern = this.pattern;
        }
        this.handleConstraintsInCopyDto(dto);
        return dto;
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((String)instance);
    }

    @Override
    public List<String> newInstanceWithJavaOrKotlin(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent, boolean isJava, boolean isVariableNullable) {
        String code;
        if (this.accessibleSchema != null && this.accessibleSchema.setterMethodName != null) {
            code = CodeJavaOrKotlinGenerator.oneLineSetterInstance(this.accessibleSchema.setterMethodName, null, variableName, this.getValueAsJavaString(isJava), isJava, isVariableNullable);
        } else {
            if (this.accessibleSchema != null && !this.accessibleSchema.isAccessible) {
                throw new IllegalStateException("Error: private field, but there is no setter method");
            }
            code = CodeJavaOrKotlinGenerator.oneLineInstance(isDeclaration, doesIncludeName, ((StringType)this.getType()).getTypeNameForInstanceInJavaOrKotlin(isJava), variableName, this.getValueAsJavaString(isJava), isJava, isVariableNullable);
        }
        return Collections.singletonList(CodeJavaOrKotlinGenerator.getIndent(indent) + code);
    }

    @Override
    public List<String> newAssertionWithJavaOrKotlin(int indent, String responseVarName, int maxAssertionForDataInCollection, boolean isJava) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaOrKotlinGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaOrKotlinGenerator.junitAssertNull(responseVarName, isJava));
        } else {
            sb.append(CodeJavaOrKotlinGenerator.junitAssertEquals(this.getValueAsJavaString(isJava), responseVarName, isJava));
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        return this.getValue() == null ? null : "\"" + CodeJavaOrKotlinGenerator.handleEscapeCharInString((String)this.getValue(), isJava) + "\"";
    }

    @Override
    public void copyProperties(NamedTypedValue copy) {
        super.copyProperties(copy);
        if (copy instanceof StringParam) {
            ((StringParam)copy).setMax(this.max);
            ((StringParam)copy).setMin(this.min);
            ((StringParam)copy).setMinSize(this.minSize);
            ((StringParam)copy).setMinSize(this.minSize);
            ((StringParam)copy).setPattern(this.pattern);
        }
        this.handleConstraintsInCopy(copy);
    }

    @Override
    public boolean getMinInclusive() {
        return this.minInclusive;
    }

    @Override
    public void setMinInclusive(boolean inclusive) {
        this.minInclusive = inclusive;
    }

    @Override
    public boolean getMaxInclusive() {
        return this.maxInclusive;
    }

    @Override
    public void setMaxInclusive(boolean inclusive) {
        this.maxInclusive = inclusive;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Integer scale) {
        this.scale = scale;
    }
}

