/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import java.util.Arrays;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.TypeDto;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PairParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PairType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;

public class MapType
extends TypeSchema {
    private static final String KOTLIN_MAP = "MutableMap";
    private final PairParam template;

    public MapType(String type, String fullTypeName, PairParam template, Class<?> clazz, JavaDtoSpec spec) {
        super(type, fullTypeName, clazz, spec);
        this.template = template;
    }

    public PairParam getTemplate() {
        return this.template;
    }

    @Override
    public TypeDto getDto() {
        TypeDto dto = super.getDto();
        ParamDto example = this.template.getDto();
        example.innerContent = Arrays.asList(((PairType)this.template.getType()).getFirstTemplate().getDto(), ((PairType)this.template.getType()).getSecondTemplate().getDto());
        dto.example = example;
        return dto;
    }

    @Override
    public String getTypeNameForInstanceInJavaOrKotlin(boolean isJava) {
        String key = ((TypeSchema)((PairType)this.template.getType()).getFirstTemplate().getType()).getTypeNameForInstanceInJavaOrKotlin(isJava);
        String value = ((TypeSchema)((PairType)this.template.getType()).getSecondTemplate().getType()).getTypeNameForInstanceInJavaOrKotlin(isJava);
        String type = this.getFullTypeName();
        if (!isJava) {
            type = KOTLIN_MAP;
        }
        return type + "<" + key + "," + value + ">";
    }

    @Override
    public MapType copy() {
        return new MapType(this.getSimpleTypeName(), this.getFullTypeName(), this.template, this.getClazz(), this.spec);
    }
}

