/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.utils.SimpleLogger;

public class ClassScanner {
    public static void forceLoading(String packagePrefixes) {
        ClassScanner.forceLoading(ClassScanner.findAllClassNames(packagePrefixes));
    }

    public static void forceLoading(Set<ClassName> names) {
        ClassLoader loader = ClassScanner.class.getClassLoader();
        for (ClassName name : names) {
            try {
                loader.loadClass(name.getFullNameWithDots());
            }
            catch (Exception e) {
                SimpleLogger.error("Failed to load " + name.getFullNameWithDots() + " : " + e.getMessage());
            }
        }
    }

    public static Set<ClassName> findAllClassNames(String packagePrefixes) {
        List<String> prefixes = Arrays.asList(packagePrefixes.split(",")).stream().map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        HashSet<ClassName> names = new HashSet<ClassName>();
        ClassScanner.searchInCurrentClassLoaderIfUrlOne(prefixes, names);
        return names;
    }

    private static void searchInCurrentClassLoaderIfUrlOne(List<String> prefixes, Set<ClassName> names) {
        for (ClassLoader loader = ClassScanner.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URLClassLoader urlLoader = (URLClassLoader)loader;
            for (URL url : urlLoader.getURLs()) {
                try {
                    URI uri = url.toURI();
                    File file = new File(uri);
                    String path = file.getAbsolutePath();
                    if (file.isDirectory()) {
                        ClassScanner.scanDirectory(prefixes, names, file, path);
                        continue;
                    }
                    if (!path.endsWith(".jar")) continue;
                    ClassScanner.scanJar(prefixes, names, path);
                }
                catch (Exception e) {
                    SimpleLogger.error("Error while parsing URL " + url);
                }
            }
        }
    }

    private static void scanDirectory(List<String> prefixes, Set<ClassName> names, File directory, String classPathFolder) {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        if (!directory.canRead()) {
            SimpleLogger.warn("No permission to read: " + directory.getAbsolutePath());
            return;
        }
        for (File file : directory.listFiles()) {
            ClassName className;
            String relativeFilePath = file.getAbsolutePath().replace(classPathFolder + File.separator, "");
            if (file.isDirectory() && ClassScanner.isAPotentialPrefix(relativeFilePath, prefixes)) {
                ClassScanner.scanDirectory(prefixes, names, file, classPathFolder);
                continue;
            }
            if (!file.getName().endsWith(".class") || !ClassScanner.isAMatch((className = ClassName.get(relativeFilePath)).getFullNameWithDots(), prefixes)) continue;
            names.add(className);
        }
    }

    private static boolean isAPotentialPrefix(String folder, List<String> prefixes) {
        String p = folder.replace(File.separatorChar, '.');
        return prefixes.stream().anyMatch(s -> s.startsWith(p));
    }

    private static boolean isAMatch(String name, List<String> prefixes) {
        return prefixes.stream().anyMatch(s -> name.startsWith((String)s));
    }

    private static void scanJar(List<String> prefixes, Set<ClassName> names, String jarEntry) {
        try (JarFile zf = new JarFile(jarEntry);){
            Enumeration<JarEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ClassName className;
                JarEntry ze = e.nextElement();
                String entryName = ze.getName();
                if (!entryName.endsWith(".class") || !ClassScanner.isAMatch((className = ClassName.get(entryName)).getFullNameWithDots(), prefixes)) continue;
                names.add(className);
            }
        }
        catch (IOException e) {
            SimpleLogger.error("Failed to open jar " + jarEntry + " : " + e.getMessage());
        }
    }
}

