/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ExternalServiceInfoUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.utils.SimpleLogger;

public class SocketClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Socket.class;
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, replacingStatic=false, usageFilter=UsageFilter.ANY)
    public static void connect(Socket caller, SocketAddress endpoint, int timeout) throws IOException {
        if (endpoint instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)endpoint;
            ExternalServiceInfoUtils.analyzeDnsResolution(socketAddress.getHostName());
            if (ExternalServiceInfoUtils.skipHostnameOrIp(socketAddress.getHostString()) || ExecutionTracer.skipHostnameAndPort(socketAddress.getHostString(), socketAddress.getPort())) {
                caller.connect(endpoint, timeout);
                return;
            }
            if (socketAddress.getAddress() instanceof Inet4Address && ExecutionTracer.hasMappingForLocalAddress(socketAddress.getHostString())) {
                String newHostname = ExecutionTracer.getRemoteHostname(socketAddress.getHostString());
                ExternalServiceInfo remoteHostInfo = new ExternalServiceInfo("TCP", newHostname, socketAddress.getPort());
                String[] ipAndPort = ExternalServiceInfoUtils.collectExternalServiceInfo(remoteHostInfo, socketAddress.getPort());
                InetSocketAddress replaced = new InetSocketAddress(InetAddress.getByName(ipAndPort[0]), Integer.parseInt(ipAndPort[1]));
                caller.connect(replaced, timeout);
                return;
            }
        }
        SimpleLogger.warn("not handle the type of endpoint yet:" + endpoint.getClass().getName());
        caller.connect(endpoint, timeout);
    }
}

