/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evomaster.client.java.sql.SqlScriptRunner;

public class SqlScriptRunnerCached {
    private static Map<String, List<String>> cache = new HashMap<String, List<String>>();
    private static final SqlScriptRunner runner = new SqlScriptRunner();

    public static void runScriptFromResourceFile(Connection connection, String ... paths) {
        for (String p : paths) {
            SqlScriptRunnerCached.runScriptFromResourceFile(connection, p);
        }
    }

    public static void runScriptFromResourceFile(Connection connection, String resourcePath) {
        List<String> sql = SqlScriptRunnerCached.extractSqlScriptFromResourceFile(resourcePath);
        SqlScriptRunner.runCommands(connection, sql);
    }

    public static List<String> extractSqlScriptFromResourceFile(String resourcePath) {
        List<String> sql = cache.get(resourcePath);
        if (sql == null) {
            try (InputStream in = SqlScriptRunner.class.getResourceAsStream(resourcePath);){
                sql = runner.readCommands(new InputStreamReader(in));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            cache.put(resourcePath, sql);
        }
        return sql;
    }
}

