/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import shaded.org.objectweb.asm.Type;

public class ReplacementUtils {
    public static String getDescriptor(Method m, int skipFirsts, int skipLast) {
        Class<?>[] parameters = m.getParameterTypes();
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        int start = skipFirsts;
        int end = parameters.length - skipLast;
        for (int i = start; i < end; ++i) {
            buf.append(Type.getDescriptor(parameters[i]));
        }
        buf.append(')');
        buf.append(Type.getDescriptor(m.getReturnType()));
        return buf.toString();
    }

    public static Optional<Method> chooseMethodFromCandidateReplacement(boolean isInSUT, String name, String desc, List<MethodReplacementClass> candidateClasses, boolean requirePure) {
        Optional<Method> r = candidateClasses.stream().filter(i -> {
            try {
                i.getClass().getDeclaredMethods();
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }).flatMap(i -> Stream.of(i.getClass().getDeclaredMethods())).filter(m -> m.getDeclaredAnnotation(Replacement.class) != null).filter(m -> m.getName().equals(name)).filter(m -> {
            Replacement br = m.getAnnotation(Replacement.class);
            if (isInSUT && br.usageFilter() == UsageFilter.ONLY_THIRD_PARTY) {
                return false;
            }
            if (!isInSUT && br.usageFilter() == UsageFilter.ONLY_SUT) {
                return false;
            }
            if (requirePure && !br.isPure()) {
                return false;
            }
            String ctg = br.category().toString();
            String categories = System.getProperty("evomaster.javaagent.replacement_categories");
            if (categories == null || !categories.contains(ctg)) {
                return false;
            }
            int skipFirst = br.replacingStatic() ? 0 : 1;
            int skipLast = br.type() == ReplacementType.TRACKER ? 0 : 1;
            return desc.equals(ReplacementUtils.getDescriptor(m, skipFirst, skipLast));
        }).findAny();
        return r;
    }
}

