/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.external;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.evomaster.client.java.instrumentation.InstrumentingAgent;
import org.evomaster.client.java.utils.SimpleLogger;

public class JarAgentLocator {
    public static String getAgentJarPath() {
        String jarFilePath = JarAgentLocator.getFromProperty();
        if (jarFilePath == null) {
            String classPath = System.getProperty("java.class.path");
            jarFilePath = JarAgentLocator.searchInAClassPath(classPath);
        }
        if (jarFilePath == null) {
            jarFilePath = JarAgentLocator.searchInCurrentClassLoaderIfUrlOne();
        }
        if (jarFilePath == null) {
            jarFilePath = JarAgentLocator.searchInCurrentClassLoaderIfItProvidesClasspathAPI();
        }
        if (jarFilePath == null) {
            jarFilePath = JarAgentLocator.searchInFolder("target");
        }
        if (jarFilePath == null) {
            jarFilePath = JarAgentLocator.searchInFolder("lib");
        }
        if (jarFilePath == null) {
            // empty if block
        }
        return jarFilePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAgentJar(String path) throws IllegalArgumentException {
        if (path.endsWith("classes")) {
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException("Non-existing file " + path);
        }
        String name = file.getName();
        if (!name.toLowerCase().contains("evomaster")) return false;
        if (!name.endsWith(".jar")) return false;
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            Attributes attributes = manifest.getMainAttributes();
            String premain = attributes.getValue("Premain-Class");
            if (premain == null || premain.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            String agentClass = attributes.getValue("Agent-Class");
            String agent = InstrumentingAgent.class.getName();
            if (agentClass == null) return false;
            if (!agentClass.trim().equalsIgnoreCase(agent)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String getFromProperty() {
        String path = System.getProperty("evomaster.instrumentation.jar.path");
        if (path == null) {
            return null;
        }
        if (!JarAgentLocator.isAgentJar(path)) {
            throw new IllegalStateException("Specified instrumenting jar file is invalid");
        }
        return path;
    }

    private static String searchInAClassPath(String classPath) {
        String[] tokens;
        for (String entry : tokens = classPath.split(File.pathSeparator)) {
            if (entry == null || entry.isEmpty() || !JarAgentLocator.isAgentJar(entry)) continue;
            return entry;
        }
        return null;
    }

    private static String searchInCurrentClassLoaderIfItProvidesClasspathAPI() {
        for (ClassLoader loader = JarAgentLocator.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            try {
                Method m = loader.getClass().getMethod("getClasspath", new Class[0]);
                String classPath = (String)m.invoke((Object)loader, new Object[0]);
                String jar = JarAgentLocator.searchInAClassPath(classPath);
                if (jar == null) continue;
                return jar;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String searchInCurrentClassLoaderIfUrlOne() {
        HashSet<URI> uris = new HashSet<URI>();
        for (ClassLoader loader = JarAgentLocator.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URLClassLoader urlLoader = (URLClassLoader)loader;
            for (URL url : urlLoader.getURLs()) {
                try {
                    URI uri = url.toURI();
                    uris.add(uri);
                    File file = new File(uri);
                    String path = file.getAbsolutePath();
                    if (!JarAgentLocator.isAgentJar(path)) continue;
                    return path;
                }
                catch (Exception e) {
                    SimpleLogger.error("Error while parsing URL " + url);
                }
            }
        }
        String msg = "Failed to find Agent jar in current classloader. URLs of classloader:";
        for (URI uri : uris) {
            msg = msg + "\n" + uri.toString();
        }
        SimpleLogger.warn(msg);
        return null;
    }

    private static String searchInFolder(String folder) {
        File target = new File(folder);
        if (!target.exists()) {
            SimpleLogger.debug("No target folder " + target.getAbsolutePath());
            return null;
        }
        if (!target.isDirectory()) {
            SimpleLogger.debug("'target' exists, but it is not a folder");
            return null;
        }
        for (File file : target.listFiles()) {
            String path = file.getAbsolutePath();
            if (!JarAgentLocator.isAgentJar(path)) continue;
            return path;
        }
        return null;
    }
}

