/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

import java.io.Serializable;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.TaintType;

public class StringSpecializationInfo
implements Serializable {
    private final StringSpecialization stringSpecialization;
    private final String value;
    private final TaintType type;

    public StringSpecializationInfo(StringSpecialization stringSpecialization, String value) {
        this(stringSpecialization, value, TaintType.FULL_MATCH);
    }

    public StringSpecializationInfo(StringSpecialization stringSpecialization, String value, TaintType taintType) {
        this.stringSpecialization = Objects.requireNonNull(stringSpecialization);
        this.value = value;
        if (taintType == null || taintType == TaintType.NONE) {
            throw new IllegalArgumentException("Invalid type: " + taintType);
        }
        this.type = taintType;
    }

    public StringSpecialization getStringSpecialization() {
        return this.stringSpecialization;
    }

    public String getValue() {
        return this.value;
    }

    public TaintType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringSpecializationInfo that = (StringSpecializationInfo)o;
        return this.stringSpecialization == that.stringSpecialization && Objects.equals(this.value, that.value) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.stringSpecialization, this.value, this.type);
    }
}

