/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.staticstate;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class UnitsInfoRecorder
implements Serializable {
    private static UnitsInfoRecorder singleton = new UnitsInfoRecorder();
    private Set<String> unitNames = new CopyOnWriteArraySet<String>();
    private AtomicInteger numberOfLines = new AtomicInteger(0);
    private AtomicInteger numberOfBranches = new AtomicInteger(0);
    private AtomicInteger numberOfReplacedMethodsInSut = new AtomicInteger(0);
    private AtomicInteger numberOfReplacedMethodsInThirdParty = new AtomicInteger(0);
    private AtomicInteger numberOfTrackedMethods = new AtomicInteger(0);
    private AtomicInteger numberOfInstrumentedNumberComparisons = new AtomicInteger(0);
    private Map<String, String> parsedDtos = new ConcurrentHashMap<String, String>();

    private UnitsInfoRecorder() {
    }

    public static void reset() {
        singleton = new UnitsInfoRecorder();
    }

    public static UnitsInfoRecorder getInstance() {
        return singleton;
    }

    public static void markNewUnit(String name) {
        UnitsInfoRecorder.singleton.unitNames.add(name);
    }

    public static void markNewLine() {
        UnitsInfoRecorder.singleton.numberOfLines.incrementAndGet();
    }

    public static void markNewBranchPair() {
        UnitsInfoRecorder.singleton.numberOfBranches.addAndGet(2);
    }

    public static void markNewReplacedMethodInSut() {
        UnitsInfoRecorder.singleton.numberOfReplacedMethodsInSut.incrementAndGet();
    }

    public static void markNewReplacedMethodInThirdParty() {
        UnitsInfoRecorder.singleton.numberOfReplacedMethodsInThirdParty.incrementAndGet();
    }

    public static void markNewTrackedMethod() {
        UnitsInfoRecorder.singleton.numberOfTrackedMethods.incrementAndGet();
    }

    public static void markNewInstrumentedNumberComparison() {
        UnitsInfoRecorder.singleton.numberOfInstrumentedNumberComparisons.incrementAndGet();
    }

    public static void registerNewParsedDto(String name, String schema) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Empty dto name");
        }
        if (schema == null || schema.isEmpty()) {
            throw new IllegalArgumentException("Empty schema");
        }
        if (!UnitsInfoRecorder.singleton.parsedDtos.containsKey(name)) {
            UnitsInfoRecorder.singleton.parsedDtos.put(name, schema);
        }
    }

    public int getNumberOfUnits() {
        return this.unitNames.size();
    }

    public Set<String> getUnitNames() {
        return Collections.unmodifiableSet(this.unitNames);
    }

    public Map<String, String> getParsedDtos() {
        return Collections.unmodifiableMap(this.parsedDtos);
    }

    public int getNumberOfLines() {
        return this.numberOfLines.get();
    }

    public int getNumberOfBranches() {
        return this.numberOfBranches.get();
    }

    public int getNumberOfReplacedMethodsInSut() {
        return this.numberOfReplacedMethodsInSut.get();
    }

    public int getNumberOfReplacedMethodsInThirdParty() {
        return this.numberOfReplacedMethodsInThirdParty.get();
    }

    public int getNumberOfTrackedMethods() {
        return this.numberOfTrackedMethods.get();
    }

    public int getNumberOfInstrumentedNumberComparisons() {
        return this.numberOfInstrumentedNumberComparisons.get();
    }
}

