/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.VertexFactory;
import shaded.org.jgrapht.generate.GraphGenerator;

public class ScaleFreeGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int size;
    private long seed;
    private Random random;

    public ScaleFreeGraphGenerator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid size: " + n + " (must be non-negative)");
        }
        this.size = n;
        this.random = new Random();
        this.seed = this.random.nextLong();
    }

    public ScaleFreeGraphGenerator(int n, long l) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid size: " + n + " (must be non-negative)");
        }
        this.size = n;
        this.random = new Random();
        this.seed = l;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        this.random.setSeed(this.seed);
        ArrayList<V> arrayList = new ArrayList<V>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            V v = vertexFactory.createVertex();
            graph.addVertex(v);
            int n2 = 0;
            while (n2 == 0 && i != 0) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (n != 0 && this.random.nextInt(n) >= (Integer)arrayList2.get(j)) continue;
                    arrayList2.set(j, (Integer)arrayList2.get(j) + 1);
                    ++n2;
                    n += 2;
                    if (this.random.nextInt(2) == 0) {
                        graph.addEdge(arrayList.get(j), v);
                        continue;
                    }
                    graph.addEdge(v, arrayList.get(j));
                }
            }
            arrayList.add(v);
            arrayList2.add(n2);
        }
    }
}

