/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.visitor.methodv;

import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;

public class SuccessCallMethodVisitor
extends MethodVisitor {
    private final String className;
    private final String methodName;
    private int currentLine;
    private int currentIndex;

    public SuccessCallMethodVisitor(MethodVisitor mv, String className, String methodName, String descriptor) {
        super(589824, mv);
        this.className = className;
        this.methodName = methodName;
        this.currentLine = 0;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        this.currentIndex = 0;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.methodName.equals("<clinit>")) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        int index = this.currentIndex++;
        String targetId = ObjectiveNaming.successCallObjectiveName(this.className, this.currentLine, index);
        ObjectiveRecorder.registerTarget(targetId);
        this.addBaseInstrumentation(index, false);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        this.addBaseInstrumentation(index, true);
    }

    private void addBaseInstrumentation(int index, boolean covered) {
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.currentLine);
        this.visitLdcInsn(index);
        this.visitLdcInsn(covered);
        this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingMethod", "(Ljava/lang/String;IIZ)V", ExecutionTracer.class.isInterface());
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + 4, maxLocals);
    }
}

