/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaintInputName {
    private static final String PREFIX = "_EM_";
    private static final String POSTFIX = "_XYZ_";
    private static final Pattern pattern = Pattern.compile("(?i)\\Q_EM_\\E\\d+\\Q_XYZ_\\E");
    public static final String EXTRA_PARAM_TAINT = "EMextraParam123";
    public static final String EXTRA_HEADER_TAINT = "x-EMextraHeader123";

    public static boolean isTaintInput(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean includesTaintInput(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public static String getTaintName(int id) {
        return TaintInputName.getTaintName(id, 0);
    }

    public static String getTaintName(int id, int minLength) {
        if (id < 0) {
            throw new IllegalArgumentException("Negative id");
        }
        if (minLength < 0) {
            throw new IllegalArgumentException("Negative minLength");
        }
        String s = "" + id;
        String taint = PREFIX + s + POSTFIX;
        if (taint.length() < minLength) {
            int diff = minLength - taint.length();
            taint = PREFIX + s + new String(new char[diff]).replace("\u0000", "0") + POSTFIX;
        }
        return taint;
    }

    public static boolean doesTaintNameSatisfiesLengthConstraints(String id, int maxLength) {
        return PREFIX.length() + POSTFIX.length() + id.length() <= maxLength;
    }
}

