/*
 * Decompiled with CFR 0.152.
 */
package shaded.dk.brics.automaton;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import shaded.dk.brics.automaton.Automaton;
import shaded.dk.brics.automaton.BasicAutomata;
import shaded.dk.brics.automaton.Datatypes;
import shaded.dk.brics.automaton.State;
import shaded.dk.brics.automaton.StatePair;
import shaded.dk.brics.automaton.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpecialOperations {
    private SpecialOperations() {
    }

    public static Set<State> reverse(Automaton automaton) {
        HashMap hashMap = new HashMap();
        Set<State> set = automaton.getStates();
        Set<State> set2 = automaton.getAcceptStates();
        for (State state : set) {
            hashMap.put(state, new HashSet());
            state.accept = false;
        }
        for (State state : set) {
            for (Transition transition : state.getTransitions()) {
                ((HashSet)hashMap.get(transition.to)).add(new Transition(transition.min, transition.max, state));
            }
        }
        for (State state : set) {
            state.transitions = (Set)hashMap.get(state);
        }
        automaton.initial.accept = true;
        automaton.initial = new State();
        for (State state : set2) {
            automaton.initial.addEpsilon(state);
        }
        automaton.deterministic = false;
        return set2;
    }

    public static Automaton overlap(Automaton automaton, Automaton automaton2) {
        Automaton automaton3 = automaton.cloneExpanded();
        automaton3.determinize();
        SpecialOperations.acceptToAccept(automaton3);
        Automaton automaton4 = automaton2.cloneExpanded();
        SpecialOperations.reverse(automaton4);
        automaton4.determinize();
        SpecialOperations.acceptToAccept(automaton4);
        SpecialOperations.reverse(automaton4);
        automaton4.determinize();
        return automaton3.intersection(automaton4).minus(BasicAutomata.makeEmptyString());
    }

    private static void acceptToAccept(Automaton automaton) {
        State state = new State();
        for (State state2 : automaton.getAcceptStates()) {
            state.addEpsilon(state2);
        }
        automaton.initial = state;
        automaton.deterministic = false;
    }

    public static Automaton singleChars(Automaton automaton) {
        State state;
        Automaton automaton2 = new Automaton();
        automaton2.initial = state = new State();
        State state2 = new State();
        state2.accept = true;
        if (automaton.isSingleton()) {
            for (int i = 0; i < automaton.singleton.length(); ++i) {
                state.transitions.add(new Transition(automaton.singleton.charAt(i), state2));
            }
        } else {
            for (State state3 : automaton.getStates()) {
                for (Transition transition : state3.transitions) {
                    state.transitions.add(new Transition(transition.min, transition.max, state2));
                }
            }
        }
        automaton2.deterministic = true;
        automaton2.removeDeadTransitions();
        return automaton2;
    }

    public static Automaton trim(Automaton automaton, String string, char c) {
        automaton = automaton.cloneExpandedIfRequired();
        State state = new State();
        SpecialOperations.addSetTransitions(state, string, state);
        state.accept = true;
        for (State state2 : automaton.getStates()) {
            State state3 = state2.step(c);
            if (state3 != null) {
                State state4 = new State();
                SpecialOperations.addSetTransitions(state4, string, state4);
                SpecialOperations.addSetTransitions(state2, string, state4);
                state4.addEpsilon(state3);
            }
            if (!state2.accept) continue;
            state2.addEpsilon(state);
        }
        State state5 = new State();
        SpecialOperations.addSetTransitions(state5, string, state5);
        state5.addEpsilon(automaton.initial);
        automaton.initial = state5;
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    private static void addSetTransitions(State state, String string, State state2) {
        for (int i = 0; i < string.length(); ++i) {
            state.transitions.add(new Transition(string.charAt(i), state2));
        }
    }

    public static Automaton compress(Automaton automaton, String string, char c) {
        automaton = automaton.cloneExpandedIfRequired();
        for (State state : automaton.getStates()) {
            State state2 = state.step(c);
            if (state2 == null) continue;
            State state3 = new State();
            SpecialOperations.addSetTransitions(state3, string, state3);
            SpecialOperations.addSetTransitions(state, string, state3);
            state3.addEpsilon(state2);
        }
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton subst(Automaton automaton, Map<Character, Set<Character>> map) {
        if (map.isEmpty()) {
            return automaton.cloneIfRequired();
        }
        TreeSet<Character> treeSet = new TreeSet<Character>(map.keySet());
        char[] cArray = new char[treeSet.size()];
        int n = 0;
        for (Character comparable : treeSet) {
            cArray[n++] = comparable.charValue();
        }
        automaton = automaton.cloneExpandedIfRequired();
        for (State state : automaton.getStates()) {
            Set<Transition> set = state.transitions;
            state.resetTransitions();
            block2: for (Transition transition : set) {
                int n2 = SpecialOperations.findIndex(transition.min, cArray);
                while (transition.min <= transition.max) {
                    if (cArray[n2] > transition.min) {
                        char c = (char)(cArray[n2] - '\u0001');
                        if (transition.max < c) {
                            c = transition.max;
                        }
                        state.transitions.add(new Transition(transition.min, c, transition.to));
                        if (c + '\u0001' > 65535) continue block2;
                        transition.min = (char)(c + '\u0001');
                        continue;
                    }
                    if (cArray[n2] < transition.min) {
                        char c = n2 + 1 < cArray.length ? (char)(cArray[++n2] - '\u0001') : (char)'\uffff';
                        if (transition.max < c) {
                            c = transition.max;
                        }
                        state.transitions.add(new Transition(transition.min, c, transition.to));
                        if (c + '\u0001' > 65535) continue block2;
                        transition.min = (char)(c + '\u0001');
                        continue;
                    }
                    for (Character c : map.get(Character.valueOf(transition.min))) {
                        state.transitions.add(new Transition(c.charValue(), transition.to));
                    }
                    if (transition.min + '\u0001' > 65535) continue block2;
                    transition.min = (char)(transition.min + '\u0001');
                    if (n2 + 1 >= cArray.length || cArray[n2 + 1] != transition.min) continue;
                    ++n2;
                }
            }
        }
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    static int findIndex(char c, char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        while (n2 - n > 1) {
            int n3 = n + n2 >>> 1;
            if (cArray[n3] > c) {
                n2 = n3;
                continue;
            }
            if (cArray[n3] < c) {
                n = n3;
                continue;
            }
            return n3;
        }
        return n;
    }

    public static Automaton subst(Automaton automaton, char c, String string) {
        automaton = automaton.cloneExpandedIfRequired();
        HashSet<StatePair> hashSet = new HashSet<StatePair>();
        for (State state : automaton.getStates()) {
            Set<Transition> set = state.transitions;
            state.resetTransitions();
            for (Transition transition : set) {
                if (transition.max < c || transition.min > c) {
                    state.transitions.add(transition);
                    continue;
                }
                if (transition.min < c) {
                    state.transitions.add(new Transition(transition.min, (char)(c - '\u0001'), transition.to));
                }
                if (transition.max > c) {
                    state.transitions.add(new Transition((char)(c + '\u0001'), transition.max, transition.to));
                }
                if (string.length() == 0) {
                    hashSet.add(new StatePair(state, transition.to));
                    continue;
                }
                State state2 = state;
                for (int i = 0; i < string.length(); ++i) {
                    State state3 = i + 1 == string.length() ? transition.to : new State();
                    state2.transitions.add(new Transition(string.charAt(i), state3));
                    state2 = state3;
                }
            }
        }
        automaton.addEpsilons(hashSet);
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton homomorph(Automaton automaton, char[] cArray, char[] cArray2) {
        automaton = automaton.cloneExpandedIfRequired();
        for (State state : automaton.getStates()) {
            Set<Transition> set = state.transitions;
            state.resetTransitions();
            for (Transition transition : set) {
                int n;
                for (int i = transition.min; i <= transition.max; i += n) {
                    int n2 = SpecialOperations.findIndex((char)i, cArray);
                    char c = (char)(cArray2[n2] + i - cArray[n2]);
                    int n3 = n2 + 1 == cArray.length ? 65535 : cArray[n2 + 1] - '\u0001';
                    n = n3 < transition.max ? n3 + 1 - i : transition.max + '\u0001' - i;
                    state.transitions.add(new Transition(c, (char)(c + n - 1), transition.to));
                }
            }
        }
        automaton.deterministic = false;
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton projectChars(Automaton automaton, Set<Character> set) {
        int n;
        Character[] characterArray = set.toArray(new Character[set.size()]);
        char[] cArray = new char[characterArray.length];
        boolean bl = false;
        for (n = 0; n < characterArray.length; ++n) {
            if (characterArray[n] == null) {
                bl = true;
                continue;
            }
            cArray[n] = characterArray[n].charValue();
        }
        Arrays.sort(cArray);
        if (automaton.isSingleton()) {
            for (n = 0; n < automaton.singleton.length(); ++n) {
                char c = automaton.singleton.charAt(n);
                if (bl && (c <= '\udfff' || c >= '\uf900') || Arrays.binarySearch(cArray, c) >= 0) continue;
                return BasicAutomata.makeEmpty();
            }
            return automaton.cloneIfRequired();
        }
        HashSet<StatePair> hashSet = new HashSet<StatePair>();
        automaton = automaton.cloneExpandedIfRequired();
        for (State state : automaton.getStates()) {
            HashSet<Transition> hashSet2 = new HashSet<Transition>();
            for (Transition transition : state.transitions) {
                boolean bl2 = false;
                if (transition.min < '\uf900' && transition.max > '\udfff') {
                    int n2;
                    int n3 = Arrays.binarySearch(cArray, transition.min > '\ue000' ? (char)transition.min : (char)'\ue000');
                    if (n3 < 0) {
                        n3 = -n3 - 1;
                        bl2 = true;
                    }
                    if ((n2 = Arrays.binarySearch(cArray, transition.max < '\uf8ff' ? (char)transition.max : (char)'\uf8ff')) < 0) {
                        n2 = -n2 - 2;
                        bl2 = true;
                    }
                    for (int i = n3; i <= n2; ++i) {
                        hashSet2.add(new Transition(cArray[i], transition.to));
                        if (i <= n3 || cArray[i - 1] + '\u0001' == cArray[i]) continue;
                        bl2 = true;
                    }
                }
                if (bl) {
                    if (transition.min <= '\udfff') {
                        hashSet2.add(new Transition(transition.min, transition.max < '\udfff' ? (char)transition.max : (char)'\udfff', transition.to));
                    }
                    if (transition.max >= '\uf900') {
                        hashSet2.add(new Transition(transition.min > '\uf900' ? (char)transition.min : (char)'\uf900', transition.max, transition.to));
                    }
                } else if (transition.min <= '\udfff' || transition.max >= '\uf900') {
                    bl2 = true;
                }
                if (!bl2) continue;
                hashSet.add(new StatePair(state, transition.to));
            }
            state.transitions = hashSet2;
        }
        automaton.reduce();
        automaton.addEpsilons(hashSet);
        automaton.removeDeadTransitions();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static boolean isFinite(Automaton automaton) {
        if (automaton.isSingleton()) {
            return true;
        }
        return SpecialOperations.isFinite(automaton.initial, new HashSet<State>(), new HashSet<State>());
    }

    private static boolean isFinite(State state, HashSet<State> hashSet, HashSet<State> hashSet2) {
        hashSet.add(state);
        for (Transition transition : state.transitions) {
            if (!hashSet.contains(transition.to) && (hashSet2.contains(transition.to) || SpecialOperations.isFinite(transition.to, hashSet, hashSet2))) continue;
            return false;
        }
        hashSet.remove(state);
        hashSet2.add(state);
        return true;
    }

    public static Set<String> getStrings(Automaton automaton, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        if (automaton.isSingleton() && automaton.singleton.length() == n) {
            hashSet.add(automaton.singleton);
        } else if (n >= 0) {
            SpecialOperations.getStrings(automaton.initial, hashSet, new StringBuilder(), n);
        }
        return hashSet;
    }

    private static void getStrings(State state, Set<String> set, StringBuilder stringBuilder, int n) {
        if (n == 0) {
            if (state.accept) {
                set.add(stringBuilder.toString());
            }
        } else {
            for (Transition transition : state.transitions) {
                for (int i = transition.min; i <= transition.max; ++i) {
                    stringBuilder.append((char)i);
                    SpecialOperations.getStrings(transition.to, set, stringBuilder, n - 1);
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
            }
        }
    }

    public static Set<String> getFiniteStrings(Automaton automaton) {
        HashSet<String> hashSet = new HashSet<String>();
        if (automaton.isSingleton()) {
            hashSet.add(automaton.singleton);
        } else if (!SpecialOperations.getFiniteStrings(automaton.initial, new HashSet<State>(), hashSet, new StringBuilder(), -1)) {
            return null;
        }
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getFiniteStrings(Automaton automaton, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        if (automaton.isSingleton()) {
            if (n <= 0) return null;
            hashSet.add(automaton.singleton);
            return hashSet;
        } else {
            if (SpecialOperations.getFiniteStrings(automaton.initial, new HashSet<State>(), hashSet, new StringBuilder(), n)) return hashSet;
            return null;
        }
    }

    private static boolean getFiniteStrings(State state, HashSet<State> hashSet, HashSet<String> hashSet2, StringBuilder stringBuilder, int n) {
        hashSet.add(state);
        for (Transition transition : state.transitions) {
            if (hashSet.contains(transition.to)) {
                return false;
            }
            for (int i = transition.min; i <= transition.max; ++i) {
                stringBuilder.append((char)i);
                if (transition.to.accept) {
                    hashSet2.add(stringBuilder.toString());
                    if (n >= 0 && hashSet2.size() > n) {
                        return false;
                    }
                }
                if (!SpecialOperations.getFiniteStrings(transition.to, hashSet, hashSet2, stringBuilder, n)) {
                    return false;
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
        }
        hashSet.remove(state);
        return true;
    }

    public static String getCommonPrefix(Automaton automaton) {
        boolean bl;
        if (automaton.isSingleton()) {
            return automaton.singleton;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<State> hashSet = new HashSet<State>();
        State state = automaton.initial;
        do {
            bl = true;
            hashSet.add(state);
            if (state.accept || state.transitions.size() != 1) continue;
            Transition transition = state.transitions.iterator().next();
            if (transition.min != transition.max || hashSet.contains(transition.to)) continue;
            stringBuilder.append(transition.min);
            state = transition.to;
            bl = false;
        } while (!bl);
        return stringBuilder.toString();
    }

    public static void prefixClose(Automaton automaton) {
        for (State state : automaton.getStates()) {
            state.setAccept(true);
        }
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
    }

    public static Automaton hexCases(Automaton automaton) {
        HashMap<Character, Set<Character>> hashMap = new HashMap<Character, Set<Character>>();
        char c = 'a';
        char c2 = 'A';
        while (c <= 'f') {
            HashSet<Character> hashSet = new HashSet<Character>();
            hashSet.add(Character.valueOf(c));
            hashSet.add(Character.valueOf(c2));
            hashMap.put(Character.valueOf(c), hashSet);
            hashMap.put(Character.valueOf(c2), hashSet);
            c = (char)(c + '\u0001');
            c2 = (char)(c2 + '\u0001');
        }
        Automaton automaton2 = Datatypes.getWhitespaceAutomaton();
        return automaton2.concatenate(automaton.subst(hashMap)).concatenate(automaton2);
    }

    public static Automaton replaceWhitespace(Automaton automaton) {
        HashMap<Character, Set<Character>> hashMap = new HashMap<Character, Set<Character>>();
        HashSet<Character> hashSet = new HashSet<Character>();
        hashSet.add(Character.valueOf(' '));
        hashSet.add(Character.valueOf('\t'));
        hashSet.add(Character.valueOf('\n'));
        hashSet.add(Character.valueOf('\r'));
        hashMap.put(Character.valueOf(' '), hashSet);
        return automaton.subst(hashMap);
    }
}

