/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.expression.operators.relational;

import shaded.net.sf.jsqlparser.expression.BinaryExpression;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;

public class LikeExpression
extends BinaryExpression {
    private boolean not = false;
    private boolean useBinary = false;
    private Expression escapeExpression = null;
    private KeyWord likeKeyWord = KeyWord.LIKE;

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean b) {
        this.not = b;
    }

    public boolean isUseBinary() {
        return this.useBinary;
    }

    public LikeExpression setUseBinary(boolean useBinary) {
        this.useBinary = useBinary;
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    @Deprecated
    public String getStringExpression() {
        return this.likeKeyWord.toString();
    }

    @Override
    public String toString() {
        String retval = this.getLeftExpression() + " " + (this.not ? "NOT " : "") + (Object)((Object)this.likeKeyWord) + " " + (this.useBinary ? "BINARY " : "") + this.getRightExpression();
        if (this.escapeExpression != null) {
            retval = retval + " ESCAPE " + this.escapeExpression;
        }
        return retval;
    }

    public Expression getEscape() {
        return this.escapeExpression;
    }

    public void setEscape(Expression escapeExpression) {
        this.escapeExpression = escapeExpression;
    }

    @Deprecated
    public boolean isCaseInsensitive() {
        return this.likeKeyWord == KeyWord.ILIKE;
    }

    @Deprecated
    public void setCaseInsensitive(boolean caseInsensitive) {
        this.likeKeyWord = KeyWord.ILIKE;
    }

    public KeyWord getLikeKeyWord() {
        return this.likeKeyWord;
    }

    public LikeExpression setLikeKeyWord(KeyWord likeKeyWord) {
        this.likeKeyWord = likeKeyWord;
        return this;
    }

    public LikeExpression setLikeKeyWord(String likeKeyWord) {
        this.likeKeyWord = KeyWord.from(likeKeyWord);
        return this;
    }

    public LikeExpression withEscape(Expression escape) {
        this.setEscape(escape);
        return this;
    }

    @Deprecated
    public LikeExpression withCaseInsensitive(boolean caseInsensitive) {
        this.setCaseInsensitive(caseInsensitive);
        return this;
    }

    public LikeExpression withNot(boolean not) {
        this.setNot(not);
        return this;
    }

    @Override
    public LikeExpression withLeftExpression(Expression arg0) {
        return (LikeExpression)super.withLeftExpression(arg0);
    }

    @Override
    public LikeExpression withRightExpression(Expression arg0) {
        return (LikeExpression)super.withRightExpression(arg0);
    }

    public static enum KeyWord {
        LIKE,
        ILIKE,
        RLIKE,
        REGEXP;


        public static KeyWord from(String keyword) {
            return Enum.valueOf(KeyWord.class, keyword.toUpperCase());
        }
    }
}

