/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.ClassesToExclude;
import org.evomaster.client.java.instrumentation.ComputeClassWriter;
import org.evomaster.client.java.instrumentation.coverage.visitor.classv.CoverageClassVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.classv.ThirdPartyClassVisitor;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.objectweb.asm.ClassReader;
import shaded.org.objectweb.asm.ClassVisitor;
import shaded.org.objectweb.asm.tree.ClassNode;

public class Instrumentator {
    private final List<String> prefixes;

    public Instrumentator(String packagePrefixesToCover) {
        Objects.requireNonNull(packagePrefixesToCover);
        this.prefixes = Arrays.asList(packagePrefixesToCover.split(",")).stream().map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (this.prefixes.isEmpty()) {
            throw new IllegalArgumentException("You have to specify at least one non-empty prefix, e.g. 'com.yourapplication'");
        }
    }

    public byte[] transformBytes(ClassLoader classLoader, ClassName className, ClassReader reader) {
        ComputeClassWriter writer;
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(className);
        Objects.requireNonNull(reader);
        if (!ClassesToExclude.checkIfCanInstrument(classLoader, className)) {
            throw new IllegalArgumentException("Cannot instrument " + className);
        }
        int asmFlags = 2;
        ClassVisitor cv = writer = new ComputeClassWriter(asmFlags, classLoader);
        int readFlags = 4;
        ClassNode cn = new ClassNode();
        reader.accept(cn, readFlags);
        cv = this.canInstrumentForCoverage(className) ? new CoverageClassVisitor(cv, className) : new ThirdPartyClassVisitor(cv, className);
        try {
            cn.accept(cv);
        }
        catch (Throwable e) {
            SimpleLogger.error("Failed to instrument " + className.getFullNameWithDots() + " : " + e.getMessage());
            return null;
        }
        UnitsInfoRecorder.registerClassLoader(className.getFullNameWithDots(), classLoader);
        return writer.toByteArray();
    }

    private boolean canInstrumentForCoverage(ClassName className) {
        String name = className.getFullNameWithDots();
        List<String> exclusions = Arrays.asList("BySpringCGLIB");
        return this.prefixes.stream().anyMatch(s -> name.startsWith((String)s)) && exclusions.stream().noneMatch(s -> name.contains((CharSequence)s));
    }
}

