/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.insert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shaded.net.sf.jsqlparser.expression.Expression;

public class InsertConflictTarget
implements Serializable {
    ArrayList<String> indexColumnNames = new ArrayList();
    Expression indexExpression;
    Expression whereExpression;
    String constraintName;

    public InsertConflictTarget(String indexColumnName, Expression indexExpression, Expression whereExpression, String constraintName) {
        this.indexColumnNames.add(indexColumnName);
        this.indexExpression = indexExpression;
        this.whereExpression = whereExpression;
        this.constraintName = constraintName;
    }

    public InsertConflictTarget(Collection<String> indexColumnName, Expression indexExpression, Expression whereExpression, String constraintName) {
        this.indexColumnNames.addAll(indexColumnName);
        this.indexExpression = indexExpression;
        this.whereExpression = whereExpression;
        this.constraintName = constraintName;
    }

    public List<String> getIndexColumnNames() {
        return this.indexColumnNames;
    }

    @Deprecated
    public String getIndexColumnName() {
        return this.indexColumnNames.isEmpty() ? null : this.indexColumnNames.get(0);
    }

    public String getIndexColumnName(int index) {
        return this.indexColumnNames.size() > index ? this.indexColumnNames.get(index) : null;
    }

    public boolean addIndexColumnName(String indexColumnName) {
        this.indexExpression = null;
        return this.indexColumnNames.add(indexColumnName);
    }

    public InsertConflictTarget withIndexColumnName(String indexColumnName) {
        this.indexExpression = null;
        this.indexColumnNames.add(indexColumnName);
        return this;
    }

    public boolean addAllIndexColumnNames(Collection<String> indexColumnName) {
        this.indexExpression = null;
        return this.indexColumnNames.addAll(indexColumnName);
    }

    public Expression getIndexExpression() {
        return this.indexExpression;
    }

    public void setIndexExpression(Expression indexExpression) {
        this.indexExpression = indexExpression;
        this.indexColumnNames.clear();
    }

    public InsertConflictTarget withIndexExpression(Expression indexExpression) {
        this.setIndexExpression(indexExpression);
        return this;
    }

    public Expression getWhereExpression() {
        return this.whereExpression;
    }

    public void setWhereExpression(Expression whereExpression) {
        this.whereExpression = whereExpression;
    }

    public InsertConflictTarget withWhereExpression(Expression whereExpression) {
        this.setWhereExpression(whereExpression);
        return this;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public InsertConflictTarget withConstraintName(String constraintName) {
        this.setConstraintName(constraintName);
        return this;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (this.constraintName == null) {
            builder.append(" ( ");
            if (!this.indexColumnNames.isEmpty()) {
                boolean insertComma = false;
                for (String s : this.indexColumnNames) {
                    builder.append(insertComma ? ", " : " ").append(s);
                    insertComma |= true;
                }
            } else {
                builder.append(" ( ").append(this.indexExpression).append(" )");
            }
            builder.append(" ");
            builder.append(") ");
            if (this.whereExpression != null) {
                builder.append(" WHERE ").append(this.whereExpression);
            }
        } else {
            builder.append(" ON CONSTRAINT ").append(this.constraintName);
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

