/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.GraphPath;
import shaded.org.jgrapht.Graphs;
import shaded.org.jgrapht.graph.GraphPathImpl;
import shaded.org.jgrapht.traverse.ClosestFirstIterator;

public final class DijkstraShortestPath<V, E> {
    private GraphPath<V, E> path;

    public DijkstraShortestPath(Graph<V, E> graph, V v, V v2) {
        this(graph, v, v2, Double.POSITIVE_INFINITY);
    }

    public DijkstraShortestPath(Graph<V, E> graph, V v, V v2, double d) {
        if (!graph.containsVertex(v2)) {
            throw new IllegalArgumentException("graph must contain the end vertex");
        }
        ClosestFirstIterator<V, E> closestFirstIterator = new ClosestFirstIterator<V, E>(graph, v, d);
        while (closestFirstIterator.hasNext()) {
            Object v3 = closestFirstIterator.next();
            if (!v3.equals(v2)) continue;
            this.createEdgeList(graph, closestFirstIterator, v, v2);
            return;
        }
        this.path = null;
    }

    public List<E> getPathEdgeList() {
        if (this.path == null) {
            return null;
        }
        return this.path.getEdgeList();
    }

    public GraphPath<V, E> getPath() {
        return this.path;
    }

    public double getPathLength() {
        if (this.path == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.path.getWeight();
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V v, V v2) {
        DijkstraShortestPath<V, E> dijkstraShortestPath = new DijkstraShortestPath<V, E>(graph, v, v2);
        return dijkstraShortestPath.getPathEdgeList();
    }

    private void createEdgeList(Graph<V, E> graph, ClosestFirstIterator<V, E> closestFirstIterator, V v, V v2) {
        E e;
        ArrayList<E> arrayList = new ArrayList<E>();
        V v3 = v2;
        while ((e = closestFirstIterator.getSpanningTreeEdge(v3)) != null) {
            arrayList.add(e);
            v3 = Graphs.getOppositeVertex(graph, e, v3);
        }
        Collections.reverse(arrayList);
        double d = closestFirstIterator.getShortestPathLength(v2);
        this.path = new GraphPathImpl<V, E>(graph, v, v2, arrayList, d);
    }
}

