/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.experimental.isomorphism;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.experimental.equivalence.EquivalenceComparator;
import shaded.org.jgrapht.experimental.equivalence.UniformEquivalenceComparator;
import shaded.org.jgrapht.experimental.isomorphism.GraphIsomorphismInspector;
import shaded.org.jgrapht.experimental.isomorphism.GraphOrdering;
import shaded.org.jgrapht.experimental.isomorphism.IsomorphismRelation;
import shaded.org.jgrapht.experimental.permutation.CollectionPermutationIter;
import shaded.org.jgrapht.util.PrefetchIterator;

abstract class AbstractExhaustiveIsomorphismInspector<V, E>
implements GraphIsomorphismInspector<IsomorphismRelation> {
    public static EquivalenceComparator<Object, Object> edgeDefaultIsomorphismComparator = new UniformEquivalenceComparator<Object, Object>();
    public static EquivalenceComparator<Object, Object> vertexDefaultIsomorphismComparator = new UniformEquivalenceComparator<Object, Object>();
    protected EquivalenceComparator<? super E, ? super Graph<V, ? super E>> edgeComparator;
    protected EquivalenceComparator<? super V, ? super Graph<? super V, E>> vertexComparator;
    protected Graph<V, E> graph1;
    protected Graph<V, E> graph2;
    private PrefetchIterator<IsomorphismRelation> nextSupplier;
    private GraphOrdering lableGraph1;
    private LinkedHashSet<V> graph1VertexSet;
    private LinkedHashSet<E> graph2EdgeSet;
    private CollectionPermutationIter<V> vertexPermuteIter;
    private Set<V> currVertexPermutation;

    public AbstractExhaustiveIsomorphismInspector(Graph<V, E> graph, Graph<V, E> graph2, EquivalenceComparator<? super V, ? super Graph<? super V, ? super E>> equivalenceComparator, EquivalenceComparator<? super E, ? super Graph<? super V, ? super E>> equivalenceComparator2) {
        this.graph1 = graph;
        this.graph2 = graph2;
        this.vertexComparator = equivalenceComparator != null ? equivalenceComparator : vertexDefaultIsomorphismComparator;
        if (equivalenceComparator2 != null) {
            this.edgeComparator = equivalenceComparator2;
        }
        this.init();
    }

    public AbstractExhaustiveIsomorphismInspector(Graph<V, E> graph, Graph<V, E> graph2) {
        this(graph, graph2, edgeDefaultIsomorphismComparator, vertexDefaultIsomorphismComparator);
    }

    private void init() {
        this.nextSupplier = new PrefetchIterator<IsomorphismRelation>(new NextFunctor());
        this.graph1VertexSet = new LinkedHashSet<V>(this.graph1.vertexSet());
        this.vertexPermuteIter = this.createPermutationIterator(this.graph1VertexSet, this.graph2.vertexSet());
        this.lableGraph1 = new GraphOrdering<V, E>(this.graph1, this.graph1VertexSet, this.graph1.edgeSet());
        this.graph2EdgeSet = new LinkedHashSet<E>(this.graph2.edgeSet());
    }

    protected abstract CollectionPermutationIter<V> createPermutationIterator(Set<V> var1, Set<V> var2);

    private IsomorphismRelation<V, E> findNextIsomorphicGraph() {
        boolean bl = false;
        IsomorphismRelation<V, E> isomorphismRelation = null;
        if (this.vertexPermuteIter != null) {
            while (this.vertexPermuteIter.hasNext()) {
                boolean bl2;
                GraphOrdering<V, E> graphOrdering;
                this.currVertexPermutation = this.vertexPermuteIter.getNextSet();
                if (!this.areVertexSetsOfTheSameEqualityGroup(this.graph1VertexSet, this.currVertexPermutation) || !this.lableGraph1.equalsByEdgeOrder(graphOrdering = new GraphOrdering<V, E>(this.graph2, this.currVertexPermutation, this.graph2EdgeSet)) || !(bl2 = this.areAllEdgesEquivalent(isomorphismRelation = new IsomorphismRelation<V, E>(new ArrayList<V>(this.graph1VertexSet), new ArrayList<V>(this.currVertexPermutation), this.graph1, this.graph2), this.edgeComparator))) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            return isomorphismRelation;
        }
        return null;
    }

    protected abstract boolean areVertexSetsOfTheSameEqualityGroup(Set<V> var1, Set<V> var2);

    protected boolean areAllEdgesEquivalent(IsomorphismRelation<V, E> isomorphismRelation, EquivalenceComparator<? super E, ? super Graph<V, E>> equivalenceComparator) {
        boolean bl = true;
        if (equivalenceComparator == null) {
            return true;
        }
        try {
            Set<E> set = this.graph1.edgeSet();
            for (E e : set) {
                E e2;
                if (equivalenceComparator.equivalenceCompare(e, e2 = isomorphismRelation.getEdgeCorrespondence(e, true), this.graph1, this.graph2)) continue;
                bl = false;
                break;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    public IsomorphismRelation nextIsoRelation() {
        return this.next();
    }

    @Override
    public boolean isIsomorphic() {
        return !this.nextSupplier.isEnumerationStartedEmpty();
    }

    @Override
    public boolean hasNext() {
        boolean bl = this.nextSupplier.hasMoreElements();
        return bl;
    }

    @Override
    public IsomorphismRelation next() {
        return this.nextSupplier.nextElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported in AdaptiveIsomorphismInspectorFactory. There is no meaning to removing an isomorphism result.");
    }

    private class NextFunctor
    implements PrefetchIterator.NextElementFunctor<IsomorphismRelation> {
        private NextFunctor() {
        }

        @Override
        public IsomorphismRelation nextElement() throws NoSuchElementException {
            IsomorphismRelation isomorphismRelation = AbstractExhaustiveIsomorphismInspector.this.findNextIsomorphicGraph();
            if (isomorphismRelation != null) {
                return isomorphismRelation;
            }
            throw new NoSuchElementException("IsomorphismInspector does not have any more elements");
        }
    }
}

