/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.distance.heuristics;

import java.util.Arrays;
import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.distance.heuristics.Truthness;

public class TruthnessUtils {
    public static double normalizeValue(double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("Negative value: " + v);
        }
        if (Double.isInfinite(v) || v == Double.MAX_VALUE) {
            return 1.0;
        }
        double normalized = v / (v + 1.0);
        assert (normalized >= 0.0 && normalized <= 1.0);
        return normalized;
    }

    public static Truthness getEqualityTruthness(int a, int b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        double normalizedDistance = TruthnessUtils.normalizeValue(distance);
        return new Truthness(1.0 - normalizedDistance, a != b ? 1.0 : 0.0);
    }

    public static Truthness getEqualityTruthness(long a, long b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        double normalizedDistance = TruthnessUtils.normalizeValue(distance);
        return new Truthness(1.0 - normalizedDistance, a != b ? 1.0 : 0.0);
    }

    public static Truthness getLessThanTruthness(double a, double b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        return new Truthness(a < b ? 1.0 : 1.0 / (1.1 + distance), a >= b ? 1.0 : 1.0 / (1.1 + distance));
    }

    public static Truthness getLessThanTruthness(long a, long b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        return new Truthness(a < b ? 1.0 : 1.0 / (1.1 + distance), a >= b ? 1.0 : 1.0 / (1.1 + distance));
    }

    public static Truthness getEqualityTruthness(double a, double b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        double normalizedDistance = TruthnessUtils.normalizeValue(distance);
        return new Truthness(1.0 - normalizedDistance, a != b ? 1.0 : 0.0);
    }

    public static Truthness getTruthnessToEmpty(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("lengths should always be non-negative. Invalid length " + len);
        }
        Truthness t = len == 0 ? new Truthness(1.0, 0.1) : new Truthness(1.0 / (1.0 + (double)len), 1.0);
        return t;
    }

    public static Truthness buildAndAggregationTruthness(Truthness ... truthnesses) {
        double averageOfTrue = TruthnessUtils.averageOfTrue(truthnesses);
        double falseOrAverageFalse = TruthnessUtils.falseOrAverageFalse(truthnesses);
        return new Truthness(averageOfTrue, falseOrAverageFalse);
    }

    private static double averageOfTrue(Truthness ... truthnesses) {
        TruthnessUtils.checkValidTruthnesses(truthnesses);
        double[] getOfTrueValues = Arrays.stream(truthnesses).mapToDouble(Truthness::getOfTrue).toArray();
        return TruthnessUtils.average(getOfTrueValues);
    }

    private static void checkValidTruthnesses(Truthness[] truthnesses) {
        if (truthnesses == null || truthnesses.length == 0 || Arrays.stream(truthnesses).anyMatch(e -> e == null)) {
            throw new IllegalArgumentException("null or empty Truthness instance");
        }
    }

    private static double average(double ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("null or empty values");
        }
        double total = 0.0;
        for (double v : values) {
            total += v;
        }
        return total / (double)values.length;
    }

    private static double averageOfFalse(Truthness ... truthnesses) {
        TruthnessUtils.checkValidTruthnesses(truthnesses);
        double[] getOfFalseValues = Arrays.stream(truthnesses).mapToDouble(Truthness::getOfFalse).toArray();
        return TruthnessUtils.average(getOfFalseValues);
    }

    private static double falseOrAverageFalse(Truthness ... truthnesses) {
        TruthnessUtils.checkValidTruthnesses(truthnesses);
        if (Arrays.stream(truthnesses).anyMatch(t -> t.isFalse())) {
            return 1.0;
        }
        return TruthnessUtils.averageOfFalse(truthnesses);
    }

    public static Truthness buildScaledTruthness(double base, double ofTrueToScale) {
        double scaledOfTrue = DistanceHelper.scaleHeuristicWithBase(ofTrueToScale, base);
        double ofFalse = 1.0;
        return new Truthness(scaledOfTrue, 1.0);
    }
}

