/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.evomaster.client.java.instrumentation.ExecutedSqlCommand;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.HostnameResolutionInfo;
import org.evomaster.client.java.instrumentation.MongoCollectionSchema;
import org.evomaster.client.java.instrumentation.MongoFindCommand;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.utils.SimpleLogger;

public class AdditionalInfo
implements Serializable {
    private final Set<String> queryParameters = new CopyOnWriteArraySet<String>();
    private final Set<String> headers = new CopyOnWriteArraySet<String>();
    private final Map<String, Set<StringSpecializationInfo>> stringSpecializations = new ConcurrentHashMap<String, Set<StringSpecializationInfo>>();
    private final Map<String, Deque<StatementDescription>> lastExecutedStatementStacks = new ConcurrentHashMap<String, Deque<StatementDescription>>();
    private final Set<ExternalServiceInfo> externalServices = new CopyOnWriteArraySet<ExternalServiceInfo>();
    private final Set<HostnameResolutionInfo> hostnameResolutionInfos = new CopyOnWriteArraySet<HostnameResolutionInfo>();
    private final Set<ExternalServiceInfo> employDefaultWM = new CopyOnWriteArraySet<ExternalServiceInfo>();
    private StatementDescription noExceptionStatement = null;
    private boolean rawAccessOfHttpBodyPayload = false;
    private final Set<String> parsedDtoNames = new CopyOnWriteArraySet<String>();
    private String lastExecutingThread = null;
    private final Set<ExecutedSqlCommand> executedSqlCommandData = new CopyOnWriteArraySet<ExecutedSqlCommand>();
    private final Set<MongoFindCommand> mongoFindCommandData = new CopyOnWriteArraySet<MongoFindCommand>();
    private final Set<MongoCollectionSchema> mongoCollectionSchemaData = new CopyOnWriteArraySet<MongoCollectionSchema>();

    public Set<ExecutedSqlCommand> getSqlInfoData() {
        return Collections.unmodifiableSet(this.executedSqlCommandData);
    }

    public Set<MongoFindCommand> getMongoInfoData() {
        return Collections.unmodifiableSet(this.mongoFindCommandData);
    }

    public Set<MongoCollectionSchema> getMongoCollectionTypeData() {
        return Collections.unmodifiableSet(this.mongoCollectionSchemaData);
    }

    public void addSqlInfo(ExecutedSqlCommand info) {
        this.executedSqlCommandData.add(info);
    }

    public void addMongoInfo(MongoFindCommand info) {
        this.mongoFindCommandData.add(info);
    }

    public void addMongoCollectionType(MongoCollectionSchema mongoCollectionSchema) {
        this.mongoCollectionSchemaData.add(mongoCollectionSchema);
    }

    public Set<String> getParsedDtoNamesView() {
        return Collections.unmodifiableSet(this.parsedDtoNames);
    }

    public void addParsedDtoName(String name) {
        this.parsedDtoNames.add(name);
    }

    public boolean isRawAccessOfHttpBodyPayload() {
        return this.rawAccessOfHttpBodyPayload;
    }

    public void setRawAccessOfHttpBodyPayload(boolean rawAccessOfHttpBodyPayload) {
        this.rawAccessOfHttpBodyPayload = rawAccessOfHttpBodyPayload;
    }

    public void addSpecialization(String taintInputName, StringSpecializationInfo info) {
        if (!ExecutionTracer.getTaintType(taintInputName).isTainted()) {
            throw new IllegalArgumentException("No valid input name: " + taintInputName);
        }
        Objects.requireNonNull(info);
        this.stringSpecializations.putIfAbsent(taintInputName, new CopyOnWriteArraySet());
        Set<StringSpecializationInfo> set = this.stringSpecializations.get(taintInputName);
        set.add(info);
    }

    public Map<String, Set<StringSpecializationInfo>> getStringSpecializationsView() {
        return Collections.unmodifiableMap(this.stringSpecializations);
    }

    public void addQueryParameter(String param) {
        if (param != null && !param.isEmpty()) {
            this.queryParameters.add(param);
        }
    }

    public Set<String> getQueryParametersView() {
        return Collections.unmodifiableSet(this.queryParameters);
    }

    public void addHeader(String header) {
        if (header != null && !header.isEmpty()) {
            this.headers.add(header);
        }
    }

    public Set<String> getHeadersView() {
        return Collections.unmodifiableSet(this.headers);
    }

    public String getLastExecutedStatement() {
        Deque<StatementDescription> stack = null;
        if (this.lastExecutingThread != null) {
            stack = this.lastExecutedStatementStacks.get(this.lastExecutingThread);
        }
        if (this.lastExecutingThread == null || stack == null || stack.isEmpty()) {
            if (this.noExceptionStatement == null) {
                return null;
            }
            return this.noExceptionStatement.line;
        }
        StatementDescription current = stack.peek();
        if (current == null) {
            return null;
        }
        return current.line;
    }

    public void pushLastExecutedStatement(String lastLine, String lastMethod) {
        String key;
        this.lastExecutingThread = key = this.getThreadIdentifier();
        this.lastExecutedStatementStacks.putIfAbsent(key, new ArrayDeque());
        Deque<StatementDescription> stack = this.lastExecutedStatementStacks.get(key);
        this.noExceptionStatement = null;
        StatementDescription statement = new StatementDescription(lastLine, lastMethod);
        StatementDescription current = stack.peek();
        if (current != null && lastMethod.equals(current.method)) {
            stack.pop();
        }
        stack.push(statement);
    }

    private String getThreadIdentifier() {
        return "" + Thread.currentThread().getId();
    }

    public void popLastExecutedStatement() {
        String key = this.getThreadIdentifier();
        Deque<StatementDescription> stack = this.lastExecutedStatementStacks.get(key);
        if (stack == null || stack.isEmpty()) {
            SimpleLogger.warn("EvoMaster instrumentation was left in an inconsistent state. This could happen if you have threads executing business logic in your instrumented classes after an action is completed (e.g., an HTTP call). This is not a problem, as long as this warning appears only seldom in the logs.");
            return;
        }
        StatementDescription statementDescription = stack.pop();
        if (stack.isEmpty()) {
            this.noExceptionStatement = statementDescription;
        }
    }

    public void addExternalService(ExternalServiceInfo hostInfo) {
        this.externalServices.add(hostInfo);
    }

    public void addHostnameInfo(HostnameResolutionInfo hostnameResolutionInfo) {
        this.hostnameResolutionInfos.add(hostnameResolutionInfo);
    }

    public Set<HostnameResolutionInfo> getHostnameInfos() {
        return Collections.unmodifiableSet(this.hostnameResolutionInfos);
    }

    public Set<ExternalServiceInfo> getExternalServices() {
        return Collections.unmodifiableSet(this.externalServices);
    }

    public void addEmployedDefaultWM(ExternalServiceInfo hostInfo) {
        this.employDefaultWM.add(hostInfo);
    }

    public Set<ExternalServiceInfo> getEmployedDefaultWM() {
        return Collections.unmodifiableSet(this.employDefaultWM);
    }

    private static class StatementDescription
    implements Serializable {
        public final String line;
        public final String method;

        public StatementDescription(String line, String method) {
            this.line = line;
            this.method = method;
        }
    }
}

