/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.Action;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.BootTimeObjectiveInfo;
import org.evomaster.client.java.instrumentation.ExtractJvmClass;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;

public class InstrumentationController {
    public static void resetForNewSearch() {
        ExecutionTracer.reset();
        ObjectiveRecorder.reset(false);
    }

    public static void resetForNewTest() {
        ExecutionTracer.reset();
        ObjectiveRecorder.clearFirstTimeEncountered();
    }

    public static void newAction(Action action) {
        ExecutionTracer.setAction(action);
    }

    public static void setKillSwitch(boolean b) {
        ExecutionTracer.setKillSwitch(b);
    }

    public static void setExecutingInitSql(boolean executingInitSql) {
        ExecutionTracer.setExecutingInitSql(executingInitSql);
    }

    public static void setExecutingInitMongo(boolean executingInitMongo) {
        ExecutionTracer.setExecutingInitMongo(executingInitMongo);
    }

    public static void setExecutingAction(boolean executingAction) {
        ExecutionTracer.setExecutingAction(executingAction);
    }

    public static void setBootingSut(boolean bootingSut) {
        ObjectiveRecorder.setBooting(bootingSut);
    }

    public static List<TargetInfo> getTargetInfos(Collection<Integer> ids, boolean fullyCovered, boolean descriptiveIds) {
        ArrayList<TargetInfo> list = new ArrayList<TargetInfo>();
        Map<String, TargetInfo> objectives = ExecutionTracer.getInternalReferenceToObjectiveCoverage();
        if (ids != null) {
            ids.stream().forEach(id -> {
                String descriptiveId = ObjectiveRecorder.getDescriptiveId(id);
                TargetInfo info = (TargetInfo)objectives.get(descriptiveId);
                if (info == null) {
                    info = TargetInfo.notReached(id);
                } else {
                    info = info.withMappedId((int)id);
                    if (!descriptiveIds) {
                        info = info.withNoDescriptiveId();
                    }
                }
                list.add(info);
            });
            ObjectiveRecorder.getTargetsSeenFirstTime().stream().forEach(s -> {
                int mappedId = ObjectiveRecorder.getMappedId(s);
                TargetInfo info = ((TargetInfo)objectives.get(s)).withMappedId(mappedId);
                list.add(info);
            });
        } else {
            List<String> seenFirstTime = ObjectiveRecorder.getTargetsSeenFirstTime();
            objectives.entrySet().stream().filter(e -> !ObjectiveRecorder.wasCollectedAtBootingTime((String)e.getKey())).map(e -> {
                TargetInfo info = ((TargetInfo)e.getValue()).enforceMappedId();
                if (!descriptiveIds && seenFirstTime.isEmpty()) {
                    info = info.withNoDescriptiveId();
                }
                return info;
            }).forEach(e -> list.add((TargetInfo)e));
        }
        if (fullyCovered) {
            return list.stream().filter(e -> e.value == 1.0).collect(Collectors.toList());
        }
        return list;
    }

    public static List<AdditionalInfo> getAdditionalInfoList() {
        return new ArrayList<AdditionalInfo>(ExecutionTracer.exposeAdditionalInfoList());
    }

    public static BootTimeObjectiveInfo getBootTimeObjectiveInfo() {
        return ObjectiveRecorder.exposeBootTimeObjectiveInfo();
    }

    public static void extractSpecifiedDto(List<String> dtoNames) {
        UnitsInfoRecorder.registerSpecifiedDtoSchema(ExtractJvmClass.extractAsSchema(dtoNames));
    }
}

