/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ExternalServiceUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.MethodReplacementPreserveSemantics;
import org.evomaster.client.java.utils.SimpleLogger;

public class SocketClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Socket.class;
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, replacingStatic=false, usageFilter=UsageFilter.ANY)
    public static void connect(Socket caller, SocketAddress endpoint) throws IOException {
        SocketClassReplacement.connect(caller, endpoint, 0);
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, replacingStatic=false, usageFilter=UsageFilter.ANY)
    public static void connect(Socket caller, SocketAddress endpoint, int timeout) throws IOException {
        if (MethodReplacementPreserveSemantics.shouldPreserveSemantics) {
            SimpleLogger.warn("Preserving semantics: java.net.socket");
            caller.connect(endpoint, timeout);
            return;
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            SimpleLogger.warn("not handle the type of socket address yet: " + endpoint.getClass().getName());
            caller.connect(endpoint, timeout);
            return;
        }
        InetSocketAddress socketAddress = (InetSocketAddress)endpoint;
        if (ExternalServiceUtils.skipHostnameOrIp(socketAddress.getHostString()) || ExecutionTracer.skipHostnameAndPort(socketAddress.getHostString(), socketAddress.getPort())) {
            caller.connect(endpoint, timeout);
            return;
        }
        ExternalServiceUtils.analyzeDnsResolution(socketAddress.getHostString());
        String hostname = ExecutionTracer.getRemoteHostname(socketAddress.getHostString());
        ExternalServiceInfo remoteHostInfo = new ExternalServiceInfo("TCP", hostname, socketAddress.getPort());
        String[] ipAndPort = ExternalServiceUtils.collectExternalServiceInfo(remoteHostInfo, socketAddress.getPort());
        String localIp = ipAndPort[0];
        int port = Integer.parseInt(ipAndPort[1]);
        InetSocketAddress replaced = new InetSocketAddress(InetAddress.getByName(localIp), port);
        caller.connect(replaced, timeout);
        if (!ExecutionTracer.hasMappingForLocalAddress(socketAddress.getHostString())) assert (localIp.equals(ExecutionTracer.getDefaultSinkholeAddress()));
    }
}

