/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.object.JsonTaint;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;

public class DocumentClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final DocumentClassReplacement singleton = new DocumentClassReplacement();
    public static final String ORG_BSON_DOCUMENT = "org.bson.Document";

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return ORG_BSON_DOCUMENT;
    }

    @Replacement(replacingStatic=true, type=ReplacementType.TRACKER, id="Document_parse_String", usageFilter=UsageFilter.ANY, category=ReplacementCategory.MONGO, castTo="org.bson.Document")
    public static Object parse(String json) {
        Method documentParseMethod = DocumentClassReplacement.getOriginalStaticMethod(singleton, "Document_parse_String");
        Class<?> documentClass = documentParseMethod.getDeclaringClass();
        JsonTaint.handlePossibleJsonTaint(json, documentClass, false);
        try {
            return documentParseMethod.invoke(null, json);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }
}

