/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.visitor.methodv;

import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;

public class CheckCastMethodVisitor
extends MethodVisitor {
    private final String className;
    private final String methodName;
    private int currentLine;
    private int currentIndex;

    public CheckCastMethodVisitor(MethodVisitor mv, String className, String methodName) {
        super(589824, mv);
        this.className = className;
        this.methodName = methodName;
        this.currentLine = 0;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        this.currentIndex = 0;
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (this.methodName.equals("<clinit>") || opcode != 192) {
            super.visitTypeInsn(opcode, type);
            return;
        }
        int index = this.currentIndex++;
        String targetId = ObjectiveNaming.checkcastObjectiveName(this.className, this.currentLine, index);
        ObjectiveRecorder.registerTarget(targetId);
        this.visitLdcInsn(type);
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.currentLine);
        this.visitLdcInsn(index);
        this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingCheckCast", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;II)Ljava/lang/Object;", ExecutionTracer.class.isInterface());
        super.visitTypeInsn(opcode, type);
        this.visitInsn(89);
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.currentLine);
        this.visitLdcInsn(index);
        this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executedCheckCast", "(Ljava/lang/Object;Ljava/lang/String;II)V", ExecutionTracer.class.isInterface());
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        int maxElementsAddedOnStackFrame = 5;
        super.visitMaxs(Math.max(maxElementsAddedOnStackFrame, maxStack), maxLocals);
    }
}

