/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;

public class ObjectiveNaming {
    public static final String CLASS = "Class";
    public static final String LINE = "Line";
    public static final String BRANCH = "Branch";
    public static final String TRUE_BRANCH = "_trueBranch";
    public static final String FALSE_BRANCH = "_falseBranch";
    public static final String METHOD_REPLACEMENT = "MethodReplacement";
    public static final String SUCCESS_CALL = "Success_Call";
    public static final String CHECKCAST = "CheckCast";
    public static final String NUMERIC_COMPARISON = "NumericComparison";
    private static final Map<String, String> cacheClass = new ConcurrentHashMap<String, String>(10000);
    private static final Map<String, Map<Integer, String>> lineCache = new ConcurrentHashMap<String, Map<Integer, String>>(10000);
    private static final Map<String, Map<Integer, Map<Integer, String>>> cacheCheckcast = new ConcurrentHashMap<String, Map<Integer, Map<Integer, String>>>(10000);
    private static final Map<String, Map<Integer, Map<Integer, String>>> cacheSuccessCall = new ConcurrentHashMap<String, Map<Integer, Map<Integer, String>>>(10000);
    private static final Map<String, Map<Integer, Map<Integer, Map<Boolean, String>>>> branchCache = new ConcurrentHashMap<String, Map<Integer, Map<Integer, Map<Boolean, String>>>>(10000);

    public static List<String> getAllObjectivePrefixes() {
        return Arrays.asList(BRANCH, LINE, CLASS, METHOD_REPLACEMENT, SUCCESS_CALL);
    }

    public static String classObjectiveName(String className) {
        return cacheClass.computeIfAbsent(className, c -> "Class_" + ClassName.get(c).getFullNameWithDots());
    }

    public static String numericComparisonObjectiveName(String id, int res) {
        String name = "NumericComparison_" + id + "_" + (res == 0 ? "EQ" : (res < 0 ? "LT" : "GT"));
        return name;
    }

    public static String lineObjectiveName(String className, int line) {
        Map map = lineCache.computeIfAbsent(className, c -> new ConcurrentHashMap(1000));
        return map.computeIfAbsent(line, l -> "Line_at_" + ClassName.get(className).getFullNameWithDots() + "_" + ObjectiveNaming.padNumber(line));
    }

    public static String checkcastObjectiveName(String className, int line, int index) {
        Map m0 = cacheCheckcast.computeIfAbsent(className, c -> new ConcurrentHashMap(10000));
        Map m1 = m0.computeIfAbsent(line, l -> new ConcurrentHashMap(10));
        return m1.computeIfAbsent(index, i -> "CheckCast_at_" + ClassName.get(className).getFullNameWithDots() + "_" + ObjectiveNaming.padNumber(line) + "_" + index);
    }

    public static String successCallObjectiveName(String className, int line, int index) {
        Map m0 = cacheSuccessCall.computeIfAbsent(className, c -> new ConcurrentHashMap(10000));
        Map m1 = m0.computeIfAbsent(line, l -> new ConcurrentHashMap(10));
        return m1.computeIfAbsent(index, i -> "Success_Call_at_" + ClassName.get(className).getFullNameWithDots() + "_" + ObjectiveNaming.padNumber(line) + "_" + index);
    }

    public static String methodReplacementObjectiveNameTemplate(String className, int line, int index) {
        String name = "MethodReplacement_at_" + ClassName.get(className).getFullNameWithDots() + "_" + ObjectiveNaming.padNumber(line) + "_" + index;
        return name;
    }

    public static String methodReplacementObjectiveName(String template, boolean result, ReplacementType type) {
        if (template == null || !template.startsWith(METHOD_REPLACEMENT)) {
            throw new IllegalArgumentException("Invalid template for boolean method replacement: " + template);
        }
        String name = template + "_" + type.name() + "_" + result;
        return name;
    }

    public static String branchObjectiveName(String className, int line, int branchId, boolean thenBranch, int opcode) {
        Map m0 = branchCache.computeIfAbsent(className, k -> new ConcurrentHashMap(10000));
        Map m1 = m0.computeIfAbsent(line, k -> new ConcurrentHashMap(10));
        Map m2 = m1.computeIfAbsent(branchId, k -> new ConcurrentHashMap(2));
        return m2.computeIfAbsent(thenBranch, k -> {
            String name = "Branch_at_" + ClassName.get(className).getFullNameWithDots() + "_at_line_" + ObjectiveNaming.padNumber(line) + "_position_" + branchId;
            name = thenBranch ? name + TRUE_BRANCH : name + FALSE_BRANCH;
            name = name + "_" + opcode;
            return name;
        });
    }

    private static String padNumber(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("Negative number to pad");
        }
        if (val < 10) {
            return "0000" + val;
        }
        if (val < 100) {
            return "000" + val;
        }
        if (val < 1000) {
            return "00" + val;
        }
        if (val < 10000) {
            return "0" + val;
        }
        return "" + val;
    }
}

