/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.staticstate;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.evomaster.client.java.instrumentation.ClassAnalyzer;
import org.evomaster.client.java.instrumentation.JpaConstraint;

public class UnitsInfoRecorder
implements Serializable {
    private static UnitsInfoRecorder singleton = new UnitsInfoRecorder();
    private Set<String> unitNames = new CopyOnWriteArraySet<String>();
    private AtomicInteger numberOfLines = new AtomicInteger(0);
    private AtomicInteger numberOfBranches = new AtomicInteger(0);
    private AtomicInteger numberOfReplacedMethodsInSut = new AtomicInteger(0);
    private AtomicInteger numberOfReplacedMethodsInThirdParty = new AtomicInteger(0);
    private AtomicInteger numberOfTrackedMethods = new AtomicInteger(0);
    private AtomicInteger numberOfInstrumentedNumberComparisons = new AtomicInteger(0);
    private Map<String, String> parsedDtos = new ConcurrentHashMap<String, String>();
    private List<JpaConstraint> jpaConstraints = new CopyOnWriteArrayList<JpaConstraint>();
    private volatile boolean analyzedClasses = false;
    private Map<String, String> extractedSpecifiedDtos = new ConcurrentHashMap<String, String>();
    private transient Map<String, List<ClassLoader>> classLoaders = new ConcurrentHashMap<String, List<ClassLoader>>();
    private Set<String> methodReplacements = new CopyOnWriteArraySet<String>();

    private UnitsInfoRecorder() {
    }

    public static void reset() {
        UnitsInfoRecorder copy = new UnitsInfoRecorder();
        copy.classLoaders.putAll(UnitsInfoRecorder.singleton.classLoaders);
        singleton = copy;
    }

    public static UnitsInfoRecorder getInstance() {
        return singleton;
    }

    public static Set<String> getMethodReplacementInfo() {
        return UnitsInfoRecorder.singleton.methodReplacements;
    }

    public static void forceLoadingLazyDataStructures() {
        singleton.getJpaConstraints();
    }

    public static void registerClassLoader(String className, ClassLoader classLoader) {
        UnitsInfoRecorder.singleton.classLoaders.putIfAbsent(className, new CopyOnWriteArrayList());
        UnitsInfoRecorder.singleton.classLoaders.get(className).add(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markNewUnit(String name) {
        UnitsInfoRecorder unitsInfoRecorder = singleton;
        synchronized (unitsInfoRecorder) {
            UnitsInfoRecorder.singleton.unitNames.add(name);
            UnitsInfoRecorder.singleton.analyzedClasses = false;
            UnitsInfoRecorder.singleton.jpaConstraints.clear();
        }
    }

    public static void markNewLine() {
        UnitsInfoRecorder.singleton.numberOfLines.incrementAndGet();
    }

    public static void markNewBranchPair() {
        UnitsInfoRecorder.singleton.numberOfBranches.addAndGet(2);
    }

    public static void markNewReplacedMethodInSut(String debugInfo) {
        UnitsInfoRecorder.singleton.numberOfReplacedMethodsInSut.incrementAndGet();
        UnitsInfoRecorder.singleton.methodReplacements.add(debugInfo);
    }

    public static void markNewReplacedMethodInThirdParty(String debugInfo) {
        UnitsInfoRecorder.singleton.numberOfReplacedMethodsInThirdParty.incrementAndGet();
        UnitsInfoRecorder.singleton.methodReplacements.add(debugInfo);
    }

    public static void markNewTrackedMethod(String debugInfo) {
        UnitsInfoRecorder.singleton.numberOfTrackedMethods.incrementAndGet();
        UnitsInfoRecorder.singleton.methodReplacements.add(debugInfo);
    }

    public static void markNewInstrumentedNumberComparison() {
        UnitsInfoRecorder.singleton.numberOfInstrumentedNumberComparisons.incrementAndGet();
    }

    public static void registerNewParsedDto(String name, String schema) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Empty dto name");
        }
        if (schema == null || schema.isEmpty()) {
            throw new IllegalArgumentException("Empty schema");
        }
        if (!UnitsInfoRecorder.singleton.parsedDtos.containsKey(name)) {
            UnitsInfoRecorder.singleton.parsedDtos.put(name, schema);
        }
    }

    public static Boolean isDtoSchemaRegister(String name) {
        return UnitsInfoRecorder.singleton.parsedDtos.containsKey(name);
    }

    public static void registerSpecifiedDtoSchema(Map<String, String> schemaMap) {
        for (String name : schemaMap.keySet()) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("registerSpecifiedDtoSchema: empty dto name");
            }
            String schema = schemaMap.get(name);
            if (schema == null || schema.isEmpty()) {
                throw new IllegalArgumentException("registerSpecifiedDtoSchema: empty schema");
            }
            if (UnitsInfoRecorder.singleton.extractedSpecifiedDtos.containsKey(name)) continue;
            UnitsInfoRecorder.singleton.extractedSpecifiedDtos.put(name, schema);
        }
    }

    public static void registerNewJpaConstraint(JpaConstraint constraint) {
        UnitsInfoRecorder.singleton.jpaConstraints.add(constraint);
    }

    public ClassLoader getSutClassLoader() {
        if (this.unitNames.isEmpty()) {
            return null;
        }
        return this.classLoaders.get(this.unitNames.stream().findFirst().get()).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JpaConstraint> getJpaConstraints() {
        UnitsInfoRecorder unitsInfoRecorder = singleton;
        synchronized (unitsInfoRecorder) {
            if (!this.analyzedClasses) {
                ClassAnalyzer.doAnalyze(this.unitNames);
                this.analyzedClasses = true;
            }
            return Collections.unmodifiableList(this.jpaConstraints);
        }
    }

    public boolean areClassesAnalyzed() {
        return this.analyzedClasses;
    }

    public int getNumberOfUnits() {
        return this.unitNames.size();
    }

    public Set<String> getUnitNames() {
        return Collections.unmodifiableSet(this.unitNames);
    }

    public Map<String, String> getParsedDtos() {
        return Collections.unmodifiableMap(this.parsedDtos);
    }

    public Map<String, String> getExtractedSpecifiedDtos() {
        return Collections.unmodifiableMap(this.extractedSpecifiedDtos);
    }

    public int getNumberOfLines() {
        return this.numberOfLines.get();
    }

    public int getNumberOfBranches() {
        return this.numberOfBranches.get();
    }

    public int getNumberOfReplacedMethodsInSut() {
        return this.numberOfReplacedMethodsInSut.get();
    }

    public int getNumberOfReplacedMethodsInThirdParty() {
        return this.numberOfReplacedMethodsInThirdParty.get();
    }

    public int getNumberOfTrackedMethods() {
        return this.numberOfTrackedMethods.get();
    }

    public int getNumberOfInstrumentedNumberComparisons() {
        return this.numberOfInstrumentedNumberComparisons.get();
    }

    public List<ClassLoader> getClassLoaders(String className) {
        return this.classLoaders.get(className);
    }

    public ClassLoader getFirstClassLoader(String className) {
        List<ClassLoader> loaders = this.getClassLoaders(className);
        if (loaders == null || loaders.isEmpty()) {
            return null;
        }
        return loaders.get(0);
    }
}

