/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.RegExp;

public abstract class RegExpVisitor<K> {
    public final K visitRegExp(RegExp e) {
        switch (e.kind) {
            case REGEXP_ANYCHAR: {
                return this.visitAnyChar();
            }
            case REGEXP_ANYSTRING: {
                return this.visitAnyString();
            }
            case REGEXP_AUTOMATON: {
                return this.visitAutomaton(e);
            }
            case REGEXP_CHAR: {
                return this.visitChar(e.c);
            }
            case REGEXP_CHAR_RANGE: {
                return this.visitCharRange(e.from, e.to);
            }
            case REGEXP_COMPLEMENT: {
                return this.visitComplement(e.exp1);
            }
            case REGEXP_CONCATENATION: {
                return this.visitConcatenation(e.exp1, e.exp2);
            }
            case REGEXP_EMPTY: {
                return this.visitEmpty();
            }
            case REGEXP_INTERSECTION: {
                return this.visitIntersection(e.exp1, e.exp2);
            }
            case REGEXP_INTERVAL: {
                return this.visitInterval(e.min, e.max);
            }
            case REGEXP_OPTIONAL: {
                return this.visitOptional(e.exp1);
            }
            case REGEXP_REPEAT: {
                return this.visitRepeat(e.exp1);
            }
            case REGEXP_REPEAT_MIN: {
                return this.visitRepeatMin(e.exp1, e.min);
            }
            case REGEXP_REPEAT_MINMAX: {
                return this.visitRepeatMinMax(e.exp1, e.min, e.max);
            }
            case REGEXP_STRING: {
                return this.visitString(e.s);
            }
            case REGEXP_UNION: {
                return this.visitUnion(e.exp1, e.exp2);
            }
        }
        throw new IllegalArgumentException("Unsupported kind ogf regular expression " + e.kind);
    }

    public abstract K visitUnion(RegExp var1, RegExp var2);

    public abstract K visitString(String var1);

    public abstract K visitRepeatMinMax(RegExp var1, int var2, int var3);

    public abstract K visitRepeatMin(RegExp var1, int var2);

    public abstract K visitRepeat(RegExp var1);

    public abstract K visitOptional(RegExp var1);

    public abstract K visitInterval(int var1, int var2);

    public abstract K visitIntersection(RegExp var1, RegExp var2);

    public abstract K visitEmpty();

    public abstract K visitConcatenation(RegExp var1, RegExp var2);

    public abstract K visitComplement(RegExp var1);

    public abstract K visitCharRange(char var1, char var2);

    public abstract K visitChar(char var1);

    public abstract K visitAutomaton(RegExp var1);

    public abstract K visitAnyString();

    public abstract K visitAnyChar();
}

