/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.NullTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class NullTraceObserver
extends AssertionTraceObserver<NullTraceEntry> {
    @Override
    public synchronized void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        if (statement instanceof FunctionalMockStatement) {
            return;
        }
        this.visitReturnValue(statement, scope);
    }

    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        logger.debug("Checking for null of " + var);
        try {
            if (var == null || var.isPrimitive() || var.isEnum() || currentTest.getStatement(var.getStPosition()) instanceof PrimitiveStatement || currentTest.getStatement(var.getStPosition()).isAssignmentStatement()) {
                return;
            }
            if (var.getType() != null && var.getType().equals(Void.class)) {
                return;
            }
            if (statement instanceof PrimitiveStatement) {
                return;
            }
            if (statement instanceof ArrayStatement) {
                return;
            }
            Object object = var.getObject(scope);
            this.trace.addEntry(statement.getPosition(), var, new NullTraceEntry(var, object == null));
        }
        catch (CodeUnderTestException e) {
            logger.debug("", (Throwable)e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

