/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.assertion.PrimitiveFieldAssertion;
import org.evosuite.regression.ObjectDistanceCalculator;
import org.evosuite.testcase.variable.VariableReference;

public class PrimitiveFieldTraceEntry
implements OutputTraceEntry {
    private final Map<Field, Object> fieldMap = new HashMap<Field, Object>();
    private final Map<String, Field> signatureFieldMap = new HashMap<String, Field>();
    private final VariableReference var;

    public PrimitiveFieldTraceEntry(VariableReference var) {
        this.var = var;
    }

    public void addValue(Field field, Object value) {
        this.fieldMap.put(field, value);
        this.signatureFieldMap.put(field.toString(), field);
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof PrimitiveFieldTraceEntry) {
            PrimitiveFieldTraceEntry otherEntry = (PrimitiveFieldTraceEntry)other;
            for (Field field : this.fieldMap.keySet()) {
                if (!otherEntry.fieldMap.containsKey(field)) continue;
                Object o1 = this.fieldMap.get(field);
                Object o2 = otherEntry.fieldMap.get(field);
                if (o1 == null) {
                    return o2 != null;
                }
                return !o1.equals(o2);
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions;
        block6: {
            assertions = new HashSet<Assertion>();
            if (!(other instanceof PrimitiveFieldTraceEntry)) break block6;
            PrimitiveFieldTraceEntry otherEntry = (PrimitiveFieldTraceEntry)other;
            if (Properties.isRegression()) {
                for (String fieldSignature : this.signatureFieldMap.keySet()) {
                    double distance;
                    if (!otherEntry.signatureFieldMap.containsKey(fieldSignature) || otherEntry.fieldMap.get(otherEntry.signatureFieldMap.get(fieldSignature)).equals(this.fieldMap.get(this.signatureFieldMap.get(fieldSignature))) || (distance = ObjectDistanceCalculator.getObjectDistance(this.fieldMap.get(this.signatureFieldMap.get(fieldSignature)), otherEntry.fieldMap.get(otherEntry.signatureFieldMap.get(fieldSignature)))) == 0.0) continue;
                    PrimitiveFieldAssertion assertion = new PrimitiveFieldAssertion();
                    assertion.value = this.fieldMap.get(this.signatureFieldMap.get(fieldSignature));
                    assertion.field = this.signatureFieldMap.get(fieldSignature);
                    assertion.source = this.var;
                    assertion.setComment("// (Field) Original Value: " + this.fieldMap.get(this.signatureFieldMap.get(fieldSignature)) + " | Regression Value: " + otherEntry.fieldMap.get(otherEntry.signatureFieldMap.get(fieldSignature)));
                    assertions.add(assertion);
                    assert (assertion.isValid());
                }
            } else {
                for (Field field : this.fieldMap.keySet()) {
                    if (!otherEntry.fieldMap.containsKey(field) || otherEntry.fieldMap.get(field).equals(this.fieldMap.get(field))) continue;
                    PrimitiveFieldAssertion assertion = new PrimitiveFieldAssertion();
                    assertion.value = this.fieldMap.get(field);
                    assertion.field = field;
                    assertion.source = this.var;
                    assertions.add(assertion);
                    assert (assertion.isValid());
                }
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        for (Field field : this.fieldMap.keySet()) {
            PrimitiveFieldAssertion assertion = new PrimitiveFieldAssertion();
            assertion.value = this.fieldMap.get(field);
            assertion.field = field;
            assertion.source = this.var;
            assertions.add(assertion);
            assert (assertion.isValid());
        }
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof PrimitiveFieldAssertion) {
            PrimitiveFieldAssertion ass = (PrimitiveFieldAssertion)assertion;
            if (ass.source.equals(this.var)) {
                if (Properties.isRegression()) {
                    if (ass.field != null && this.signatureFieldMap.containsKey(ass.field.toString()) && this.fieldMap.containsKey(this.signatureFieldMap.get(ass.field.toString()))) {
                        return !this.fieldMap.get(this.signatureFieldMap.get(ass.field.toString())).equals(ass.value);
                    }
                } else if (this.fieldMap.containsKey(ass.field)) {
                    return !this.fieldMap.get(ass.field).equals(ass.value);
                }
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        PrimitiveFieldTraceEntry copy = new PrimitiveFieldTraceEntry(this.var);
        copy.fieldMap.putAll(this.fieldMap);
        copy.signatureFieldMap.putAll(this.signatureFieldMap);
        return copy;
    }
}

