/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.runtime.InitializingListenerUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceList {
    private static Logger logger = LoggerFactory.getLogger(ResourceList.class);
    private Cache cache = null;
    private static Map<ClassLoader, ResourceList> instanceMap = new HashMap<ClassLoader, ResourceList>();
    private final ClassLoader classLoader;

    private ResourceList(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ResourceList getInstance(ClassLoader classLoader) {
        if (!instanceMap.containsKey(classLoader)) {
            instanceMap.put(classLoader, new ResourceList(classLoader));
        }
        return instanceMap.get(classLoader);
    }

    public void resetCache() {
        if (this.cache != null) {
            this.cache.close();
        }
        this.cache = null;
    }

    public static void resetAllCaches() {
        instanceMap.clear();
    }

    public boolean hasClass(String className) {
        return this.getCache().mapClassToCP.containsKey(className);
    }

    public InputStream getClassAsStream(String name) {
        String path = name.replace('.', '/') + ".class";
        String windowsPath = name.replace(".", "\\") + ".class";
        String cpEntry = this.getCache().mapClassToCP.get(name);
        if (cpEntry == null) {
            InputStream ins = ResourceList.getClassAsStreamFromClassLoader(name);
            if (ins != null) {
                return ins;
            }
            if (!this.getCache().missingClasses.contains(name)) {
                this.getCache().missingClasses.add(name);
                logger.debug("The class " + name + " is not on the classpath");
            }
            return null;
        }
        if (cpEntry.endsWith(".jar")) {
            JarFile jar = this.getCache().getJar(cpEntry);
            if (jar == null) {
                return null;
            }
            JarEntry entry = jar.getJarEntry(path);
            if (entry == null) {
                logger.error("Error: could not find " + path + " inside of jar file " + cpEntry);
                return null;
            }
            InputStream is = null;
            try {
                is = jar.getInputStream(entry);
            }
            catch (IOException e) {
                logger.error("Error while reading jar file " + cpEntry + ": " + e.getMessage(), (Throwable)e);
                return null;
            }
            return is;
        }
        File classFile = null;
        classFile = File.separatorChar != '/' ? new File(cpEntry + File.separator + windowsPath) : new File(cpEntry + File.separator + path);
        if (!classFile.exists()) {
            logger.error("Could not find " + classFile);
        }
        try {
            return new FileInputStream(classFile);
        }
        catch (FileNotFoundException e) {
            logger.error("Error while trying to open stream on: " + classFile.getAbsolutePath());
            return null;
        }
    }

    public Set<String> getAllClasses(String classPathEntry, boolean includeInternalClasses) {
        return this.getAllClasses(classPathEntry, "", includeInternalClasses);
    }

    public Set<String> getAllClasses(String classPathEntry, String prefix, boolean includeInternalClasses) {
        return this.getAllClasses(classPathEntry, prefix, includeInternalClasses, true);
    }

    public Set<String> getAllClasses(String classPathEntry, String prefix, boolean includeInternalClasses, boolean excludeAnonymous) {
        if (classPathEntry.contains(File.pathSeparator)) {
            LinkedHashSet<String> retval = new LinkedHashSet<String>();
            for (String element : classPathEntry.split(File.pathSeparator)) {
                retval.addAll(this.getAllClasses(element, prefix, includeInternalClasses, excludeAnonymous));
            }
            return retval;
        }
        classPathEntry = new File(classPathEntry).getAbsolutePath();
        this.addEntry(classPathEntry);
        Set<String> cps = this.getCache().mapPrefixToCPs.get(prefix);
        if (cps == null || !cps.contains(classPathEntry)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        for (String className : this.getCache().mapCPtoClasses.get(classPathEntry)) {
            if (!className.startsWith(prefix) || !includeInternalClasses && className.contains("$") || includeInternalClasses && excludeAnonymous && className.matches(".*\\$\\d+$")) continue;
            classes.add(className);
        }
        return classes;
    }

    public static boolean isInterface(String resource) throws IOException {
        InputStream input = ResourceList.class.getClassLoader().getResourceAsStream(resource);
        return ResourceList.isClassAnInterface(input);
    }

    public boolean isClassAnInterface(String className) throws IOException {
        InputStream input = this.getClassAsStream(className);
        return ResourceList.isClassAnInterface(input);
    }

    public boolean isClassDeprecated(String className) throws IOException {
        InputStream input = this.getClassAsStream(className);
        return ResourceList.isClassDeprecated(input);
    }

    public boolean isClassTestable(String className) throws IOException {
        InputStream input = this.getClassAsStream(className);
        return ResourceList.isClassTestable(input);
    }

    public static String getClassNameFromResourcePath(String resource) {
        return InitializingListenerUtils.getClassNameFromResourcePath((String)resource);
    }

    private static InputStream getClassAsStreamFromClassLoader(String name) {
        String path = name.replace('.', '/') + ".class";
        String windowsPath = name.replace(".", "\\") + ".class";
        InputStream is = ClassLoader.getSystemResourceAsStream(path);
        if (is != null) {
            return is;
        }
        if (File.separatorChar != '/' && (is = ClassLoader.getSystemResourceAsStream(windowsPath)) != null) {
            return is;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClassAnInterface(InputStream input) throws IOException {
        try {
            ClassReader reader = new ClassReader(input);
            ClassNode cn = new ClassNode();
            reader.accept((ClassVisitor)cn, 4);
            boolean bl = (cn.access & 0x200) == 512;
            return bl;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClassDeprecated(InputStream input) throws IOException {
        try {
            ClassReader reader = new ClassReader(input);
            ClassNode cn = new ClassNode();
            reader.accept((ClassVisitor)cn, 4);
            boolean bl = (cn.access & 0x20000) == 131072;
            return bl;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClassTestable(InputStream input) throws IOException {
        try {
            ClassReader reader = new ClassReader(input);
            ClassNode cn = new ClassNode();
            reader.accept((ClassVisitor)cn, 4);
            List l = cn.methods;
            for (MethodNode m : l) {
                if ((m.access & 1) != 1 && (m.access & 4) != 4 && (m.access & 2) != 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            input.close();
        }
    }

    protected static String getParentPackageName(String className) {
        if (className == null || className.isEmpty()) {
            return className;
        }
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return className.substring(0, index);
    }

    private Cache getCache() {
        if (this.cache == null) {
            this.initCache();
        }
        return this.cache;
    }

    private void initCache() {
        this.cache = new Cache();
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        if (Properties.isRegression() && this.classLoader == TestGenerationContext.getInstance().getRegressionClassLoaderForSUT()) {
            cp = Properties.REGRESSIONCP;
        }
        for (String entry : cp.split(File.pathSeparator)) {
            this.addEntry(entry);
        }
    }

    private void addEntry(String classPathElement) throws IllegalArgumentException {
        File file = new File(classPathElement);
        if (this.getCache().mapCPtoClasses.containsKey(classPathElement = file.getAbsolutePath())) {
            return;
        }
        this.getCache().mapCPtoClasses.put(classPathElement, new LinkedHashSet());
        if (!file.exists()) {
            throw new IllegalArgumentException("The class path resource " + file.getAbsolutePath() + " does not exist");
        }
        if (file.isDirectory()) {
            this.scanDirectory(file, classPathElement);
        } else if (file.getName().endsWith(".jar")) {
            this.scanJar(classPathElement);
        } else {
            throw new IllegalArgumentException("The class path resource " + file.getAbsolutePath() + " is not valid");
        }
    }

    private void scanDirectory(File directory, String classPathFolder) {
        File[] fileList;
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            return;
        }
        if (!directory.canRead()) {
            logger.warn("No permission to read: " + directory.getAbsolutePath());
            return;
        }
        String prefix = directory.getAbsolutePath().replace(classPathFolder + File.separator, "");
        prefix = prefix.replace(File.separatorChar, '.');
        for (File file : fileList = directory.listFiles()) {
            String outerClass;
            String relativeFilePath;
            String className;
            if (file.isDirectory()) {
                this.scanDirectory(file, classPathFolder);
                continue;
            }
            if (!file.getName().endsWith(".class") || this.getCache().mapClassToCP.containsKey(className = ResourceList.getClassNameFromResourcePath(relativeFilePath = file.getAbsolutePath().replace(classPathFolder + File.separator, ""))) || className.contains("$") && this.getCache().mapClassToCP.containsKey(outerClass = className.substring(0, className.indexOf(36))) && !this.getCache().mapClassToCP.get(outerClass).equals(classPathFolder)) continue;
            this.getCache().mapClassToCP.put(className, classPathFolder);
            this.getCache().mapCPtoClasses.get(classPathFolder).add(className);
            this.getCache().addPrefix(prefix, classPathFolder);
        }
    }

    private void scanJar(String jarEntry) {
        JarFile zf = this.getCache().getJar(jarEntry);
        Enumeration<JarEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            String outerClass;
            String className;
            JarEntry ze = e.nextElement();
            String entryName = ze.getName();
            if (!entryName.endsWith(".class") || this.getCache().mapClassToCP.containsKey(className = ResourceList.getClassNameFromResourcePath(entryName)) || className.contains("$") && this.getCache().mapClassToCP.containsKey(outerClass = className.substring(0, className.indexOf(36))) && !this.getCache().mapClassToCP.get(outerClass).equals(jarEntry)) continue;
            this.getCache().mapClassToCP.put(className, jarEntry);
            this.getCache().mapCPtoClasses.get(jarEntry).add(className);
            this.getCache().addPrefix(ResourceList.getParentPackageName(className), jarEntry);
        }
    }

    private static class Cache {
        public Map<String, Set<String>> mapCPtoClasses = new LinkedHashMap<String, Set<String>>();
        public Map<String, String> mapClassToCP = new LinkedHashMap<String, String>();
        public Map<String, Set<String>> mapPrefixToCPs = new LinkedHashMap<String, Set<String>>();
        public Set<String> missingClasses = new LinkedHashSet<String>();
        public Map<String, JarFile> openedJars = new LinkedHashMap<String, JarFile>();

        private Cache() {
        }

        public void addPrefix(String prefix, String cpEntry) {
            Set<String> classPathEntries = this.mapPrefixToCPs.get(prefix);
            if (classPathEntries == null) {
                classPathEntries = new LinkedHashSet<String>();
                this.mapPrefixToCPs.put(prefix, classPathEntries);
            }
            classPathEntries.add(cpEntry);
            if (!prefix.isEmpty()) {
                String parent = ResourceList.getParentPackageName(prefix);
                this.addPrefix(parent, cpEntry);
            }
        }

        public JarFile getJar(String entry) {
            if (this.openedJars.containsKey(entry)) {
                return this.openedJars.get(entry);
            }
            try {
                JarFile jar = new JarFile(entry);
                this.openedJars.put(entry, jar);
                return jar;
            }
            catch (IOException e) {
                logger.error("Error while reading jar file " + entry + ": " + e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public void close() {
            for (JarFile jar : this.openedJars.values()) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    logger.error("Cannot close jar file " + jar.getName() + ". " + e.toString());
                }
            }
        }
    }
}

