/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.PackageInfo;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class NullPointerExceptionContract
extends Contract {
    @Override
    public ContractViolation check(Statement statement, Scope scope, Throwable exception) {
        if (!this.isTargetStatement(statement)) {
            return null;
        }
        try {
            if (exception != null && exception instanceof NullPointerException) {
                StackTraceElement element = exception.getStackTrace()[0];
                if (element.getClassName().startsWith(PackageInfo.getEvoSuitePackage() + ".testcase")) {
                    return null;
                }
                ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
                if (statement instanceof MethodStatement) {
                    MethodStatement ms = (MethodStatement)statement;
                    parameters.addAll(ms.getParameterReferences());
                } else if (statement instanceof ConstructorStatement) {
                    ConstructorStatement cs = (ConstructorStatement)statement;
                    parameters.addAll(cs.getParameterReferences());
                } else {
                    return null;
                }
                boolean hasNull = false;
                for (VariableReference var : parameters) {
                    if (var.getObject(scope) != null) continue;
                    hasNull = true;
                    break;
                }
                if (!hasNull) {
                    return new ContractViolation(this, statement, exception, new VariableReference[0]);
                }
            }
            return null;
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void addAssertionAndComments(Statement statement, List<VariableReference> variables, Throwable exception) {
        statement.addComment("Throws NullPointerException: " + exception.getMessage());
    }

    public String toString() {
        return "NullPointerException";
    }
}

