/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageSuiteFitness;
import org.evosuite.coverage.rho.RhoCoverageSuiteFitness;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageCriteriaAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(CoverageCriteriaAnalyzer.class);
    private static Map<String, StringBuffer> coverageBitString = new TreeMap<String, StringBuffer>();

    private static boolean isMutationCriterion(Properties.Criterion criterion) {
        switch (criterion) {
            case MUTATION: 
            case WEAKMUTATION: 
            case STRONGMUTATION: 
            case ONLYMUTATION: {
                return true;
            }
        }
        return false;
    }

    private static void reinstrument(TestSuiteChromosome testSuite, Properties.Criterion criterion) {
        if (ArrayUtil.contains((Object[])Properties.SECONDARY_OBJECTIVE, (Object)Properties.SecondaryObjective.IBRANCH)) {
            ExecutionTracer.enableContext();
        }
        if (!ExecutionTracer.isTraceCallsEnabled()) {
            ExecutionTracer.enableTraceCalls();
        }
        testSuite.setChanged(true);
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            test.setChanged(true);
            test.clearCachedResults();
        }
        Properties.Criterion[] oldCriterion = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length);
        Properties.CRITERION = new Properties.Criterion[]{criterion};
        logger.info("Re-instrumenting for criterion: " + (Object)((Object)criterion));
        TestGenerationContext.getInstance().resetContext();
        Properties.getInitializedTargetClass();
        logger.info("Changing classloader of test suite for criterion: " + (Object)((Object)criterion));
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            DefaultTestCase dtest = (DefaultTestCase)test.getTestCase();
            dtest.changeClassLoader(TestGenerationContext.getInstance().getClassLoaderForSUT());
        }
        Properties.CRITERION = oldCriterion;
    }

    public static void analyzeCriteria(TestSuiteChromosome testSuite, String criteria) {
        if (!Properties.COVERAGE) {
            for (Properties.Criterion c : Properties.CRITERION) {
                logger.debug("Measuring coverage of target criterion {}", (Object)c);
                CoverageCriteriaAnalyzer.analyzeCoverage(testSuite, c.name());
            }
        }
        for (String extraCriterion : Arrays.asList(criteria.toUpperCase().split(","))) {
            if (extraCriterion.equals("CBRANCH")) {
                Properties.INSTRUMENT_METHOD_CALLS = true;
            }
            if (ArrayUtil.contains((Object[])Properties.CRITERION, extraCriterion)) continue;
            logger.debug("Measuring additional coverage of target criterion {}", (Object)extraCriterion);
            CoverageCriteriaAnalyzer.analyzeCoverage(testSuite, extraCriterion);
        }
    }

    private static void analyzeCoverage(TestSuiteChromosome testSuite, String criterion) {
        try {
            Properties.Criterion crit = Properties.Criterion.valueOf(criterion.toUpperCase());
            CoverageCriteriaAnalyzer.analyzeCoverage(testSuite, crit);
        }
        catch (IllegalArgumentException e) {
            LoggingUtils.getEvoLogger().info("* Unknown coverage criterion: " + criterion);
        }
    }

    public static RuntimeVariable getCoverageVariable(Properties.Criterion criterion) {
        switch (criterion) {
            case ALLDEFS: {
                return RuntimeVariable.AllDefCoverage;
            }
            case BRANCH: {
                return RuntimeVariable.BranchCoverage;
            }
            case CBRANCH: {
                return RuntimeVariable.CBranchCoverage;
            }
            case EXCEPTION: {
                return RuntimeVariable.ExceptionCoverage;
            }
            case DEFUSE: {
                return RuntimeVariable.DefUseCoverage;
            }
            case STATEMENT: {
                return RuntimeVariable.StatementCoverage;
            }
            case RHO: {
                return RuntimeVariable.RhoScore;
            }
            case AMBIGUITY: {
                return RuntimeVariable.AmbiguityScore;
            }
            case MUTATION: 
            case STRONGMUTATION: {
                return RuntimeVariable.MutationScore;
            }
            case ONLYMUTATION: {
                return RuntimeVariable.OnlyMutationScore;
            }
            case WEAKMUTATION: {
                return RuntimeVariable.WeakMutationScore;
            }
            case ONLYBRANCH: {
                return RuntimeVariable.OnlyBranchCoverage;
            }
            case METHODTRACE: {
                return RuntimeVariable.MethodTraceCoverage;
            }
            case METHOD: {
                return RuntimeVariable.MethodCoverage;
            }
            case METHODNOEXCEPTION: {
                return RuntimeVariable.MethodNoExceptionCoverage;
            }
            case ONLYLINE: 
            case LINE: {
                return RuntimeVariable.LineCoverage;
            }
            case OUTPUT: {
                return RuntimeVariable.OutputCoverage;
            }
            case INPUT: {
                return RuntimeVariable.InputCoverage;
            }
            case IBRANCH: {
                return RuntimeVariable.IBranchCoverage;
            }
            case REGRESSION: {
                return RuntimeVariable.BranchCoverage;
            }
            case TRYCATCH: {
                return RuntimeVariable.TryCatchCoverage;
            }
        }
        throw new RuntimeException("Criterion not supported: " + (Object)((Object)criterion));
    }

    public static void analyzeCoverage(TestSuiteChromosome testSuite) {
        LoggingUtils.getEvoLogger().info("* Going to analyze the coverage criteria");
        Properties.Criterion[] criteria = Properties.CRITERION;
        boolean recalculate = false;
        for (Properties.Criterion pc : criteria) {
            LoggingUtils.getEvoLogger().info("* Coverage analysis for criterion " + (Object)((Object)pc));
            CoverageCriteriaAnalyzer.analyzeCoverage(testSuite, pc, recalculate);
        }
    }

    public static void analyzeCoverage(TestSuiteChromosome testSuite, Properties.Criterion criterion) {
        CoverageCriteriaAnalyzer.analyzeCoverage(testSuite, criterion, true);
    }

    private static void analyzeCoverage(TestSuiteChromosome testSuite, Properties.Criterion criterion, boolean recalculate) {
        TestSuiteChromosome testSuiteCopy = testSuite.clone();
        TestFitnessFactory<? extends TestFitnessFunction> factory = FitnessFunctions.getFitnessFactory(criterion);
        if (recalculate) {
            CoverageCriteriaAnalyzer.reinstrument(testSuiteCopy, criterion);
            for (TestChromosome test : testSuiteCopy.getTestChromosomes()) {
                test.getTestCase().clearCoveredGoals();
                test.clearCachedResults();
                if (!CoverageCriteriaAnalyzer.isMutationCriterion(criterion)) continue;
                test.setChanged(true);
            }
        }
        List<? extends TestFitnessFunction> goals = factory.getCoverageGoals();
        Collections.sort(goals);
        StringBuffer buffer = new StringBuffer(goals.size());
        int covered = 0;
        for (TestFitnessFunction testFitnessFunction : goals) {
            if (testFitnessFunction.isCoveredBy(testSuiteCopy)) {
                logger.debug("Goal {} is covered", (Object)testFitnessFunction);
                ++covered;
                buffer.append("1");
                continue;
            }
            logger.debug("Goal {} is not covered", (Object)testFitnessFunction);
            buffer.append("0");
            if (!Properties.PRINT_MISSED_GOALS) continue;
            LoggingUtils.getEvoLogger().info(" - Missed goal {}", (Object)testFitnessFunction.toString());
        }
        coverageBitString.put(criterion.name(), buffer);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.CoverageBitString, coverageBitString.size() == 0 ? "0" : coverageBitString.values().toString().replace("[", "").replace("]", "").replace(", ", ""));
        RuntimeVariable bitStringVariable = CoverageCriteriaAnalyzer.getBitStringVariable(criterion);
        if (bitStringVariable != null) {
            String string = buffer.toString();
            ClientServices.getInstance().getClientNode().trackOutputVariable(bitStringVariable, string);
        }
        if (goals.isEmpty()) {
            if (criterion == Properties.Criterion.MUTATION || criterion == Properties.Criterion.STRONGMUTATION) {
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.MutationScore, 1.0);
            }
            LoggingUtils.getEvoLogger().info("* Coverage of criterion " + (Object)((Object)criterion) + ": 100% (no goals)");
            ClientServices.getInstance().getClientNode().trackOutputVariable(CoverageCriteriaAnalyzer.getCoverageVariable(criterion), 1.0);
        } else {
            ClientServices.getInstance().getClientNode().trackOutputVariable(CoverageCriteriaAnalyzer.getCoverageVariable(criterion), (double)covered / (double)goals.size());
            if (criterion == Properties.Criterion.MUTATION || criterion == Properties.Criterion.STRONGMUTATION) {
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.MutationScore, (double)covered / (double)goals.size());
            }
            LoggingUtils.getEvoLogger().info("* Coverage of criterion " + (Object)((Object)criterion) + ": " + NumberFormat.getPercentInstance().format((double)covered / (double)goals.size()));
            LoggingUtils.getEvoLogger().info("* Total number of goals: " + goals.size());
            LoggingUtils.getEvoLogger().info("* Number of covered goals: " + covered);
        }
        if (criterion == Properties.Criterion.RHO) {
            RhoCoverageSuiteFitness rhoCoverageSuiteFitness = new RhoCoverageSuiteFitness();
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.RhoScore, Math.abs(0.5 - rhoCoverageSuiteFitness.getFitness(testSuite)));
        } else if (criterion == Properties.Criterion.AMBIGUITY) {
            AmbiguityCoverageSuiteFitness ambiguityCoverageSuiteFitness = new AmbiguityCoverageSuiteFitness();
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.AmbiguityScore, ambiguityCoverageSuiteFitness.getFitness(testSuite));
        }
    }

    public static RuntimeVariable getBitStringVariable(Properties.Criterion criterion) {
        switch (criterion) {
            case EXCEPTION: {
                return RuntimeVariable.ExceptionCoverageBitString;
            }
            case DEFUSE: {
                return RuntimeVariable.DefUseCoverageBitString;
            }
            case ALLDEFS: {
                return RuntimeVariable.AllDefCoverageBitString;
            }
            case BRANCH: {
                return RuntimeVariable.BranchCoverageBitString;
            }
            case CBRANCH: {
                return RuntimeVariable.CBranchCoverageBitString;
            }
            case IBRANCH: {
                return RuntimeVariable.IBranchCoverageBitString;
            }
            case ONLYBRANCH: {
                return RuntimeVariable.OnlyBranchCoverageBitString;
            }
            case MUTATION: 
            case STRONGMUTATION: {
                return RuntimeVariable.MutationCoverageBitString;
            }
            case WEAKMUTATION: {
                return RuntimeVariable.WeakMutationCoverageBitString;
            }
            case ONLYMUTATION: {
                return RuntimeVariable.OnlyMutationCoverageBitString;
            }
            case METHODTRACE: {
                return RuntimeVariable.MethodTraceCoverageBitString;
            }
            case METHOD: {
                return RuntimeVariable.MethodCoverageBitString;
            }
            case METHODNOEXCEPTION: {
                return RuntimeVariable.MethodNoExceptionCoverageBitString;
            }
            case OUTPUT: {
                return RuntimeVariable.OutputCoverageBitString;
            }
            case INPUT: {
                return RuntimeVariable.InputCoverageBitString;
            }
            case STATEMENT: {
                return RuntimeVariable.StatementCoverageBitString;
            }
            case ONLYLINE: 
            case LINE: {
                return RuntimeVariable.LineCoverageBitString;
            }
            case REGRESSION: 
            case TRYCATCH: 
            case REGRESSIONTESTS: {
                return null;
            }
        }
        logger.debug("Criterion not supported: " + (Object)((Object)criterion));
        return null;
    }
}

