/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import org.evosuite.Properties;
import org.evosuite.coverage.ControlFlowDistance;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.MethodCall;

public class BranchCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = -6310967747257242580L;
    private final BranchCoverageGoal goal;

    public BranchCoverageTestFitness(BranchCoverageGoal goal) throws IllegalArgumentException {
        if (goal == null) {
            throw new IllegalArgumentException("goal cannot be null");
        }
        this.goal = goal;
    }

    public Branch getBranch() {
        return this.goal.getBranch();
    }

    public boolean getValue() {
        return this.goal.getValue();
    }

    public BranchCoverageGoal getBranchGoal() {
        return this.goal;
    }

    public String getClassName() {
        return this.goal.getClassName();
    }

    public String getMethod() {
        return this.goal.getMethodName();
    }

    public boolean getBranchExpressionValue() {
        return this.goal.getValue();
    }

    public double getUnfitness(ExecutableChromosome individual, ExecutionResult result) {
        double sum = 0.0;
        boolean methodExecuted = false;
        for (MethodCall call : result.getTrace().getMethodCalls()) {
            if (!call.className.equals(this.goal.getClassName()) || !call.methodName.equals(this.goal.getMethodName())) continue;
            methodExecuted = true;
            if (this.goal.getBranch() == null) continue;
            for (int i = 0; i < call.branchTrace.size(); ++i) {
                if (call.branchTrace.get(i).intValue() != this.goal.getBranch().getInstruction().getInstructionId()) continue;
                if (this.goal.getValue()) {
                    sum += call.falseDistanceTrace.get(i).doubleValue();
                    continue;
                }
                sum += call.trueDistanceTrace.get(i).doubleValue();
            }
        }
        if (this.goal.getBranch() == null) {
            sum = this.goal.getValue() ? (methodExecuted ? 1.0 : 0.0) : (methodExecuted ? 0.0 : 1.0);
        }
        return sum;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        ControlFlowDistance distance = this.goal.getDistance(result);
        double fitness = distance.getResultingBranchFitness();
        if (logger.isDebugEnabled()) {
            logger.debug("Goal at line " + this.goal.getLineNumber() + ": approach level = " + distance.getApproachLevel() + " / branch distance = " + distance.getBranchDistance() + ", fitness = " + fitness);
        }
        this.updateIndividual(this, individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().updateArchive(this, individual, fitness);
        }
        return fitness;
    }

    public String toString() {
        return this.goal.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.goal == null ? 0 : this.goal.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BranchCoverageTestFitness other = (BranchCoverageTestFitness)obj;
        return !(this.goal == null ? other.goal != null : !this.goal.equals(other.goal));
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof BranchCoverageTestFitness) {
            BranchCoverageTestFitness otherBranchFitness = (BranchCoverageTestFitness)other;
            return this.goal.compareTo(otherBranchFitness.goal);
        }
        return this.compareClassName(other);
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

