/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.coverage.ControlFlowDistance;
import org.evosuite.coverage.TestCoverageGoal;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.MethodCall;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.Statement;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlFlowDistanceCalculator {
    private static Logger logger = LoggerFactory.getLogger(ControlFlowDistanceCalculator.class);

    public static ControlFlowDistance getDistance(ExecutionResult result, Branch branch, boolean value, String className, String methodName) {
        if (result == null || className == null || methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        if (branch == null && !value) {
            throw new IllegalArgumentException("expect distance for a root branch to always have value set to true");
        }
        if (!(branch == null || branch.getMethodName().equals(methodName) && branch.getClassName().equals(className))) {
            throw new IllegalArgumentException("expect explicitly given information about a branch to coincide with the information given by that branch");
        }
        if (TestCoverageGoal.hasTimeout(result)) {
            return ControlFlowDistanceCalculator.getTimeoutDistance(result, branch);
        }
        if (branch == null) {
            return ControlFlowDistanceCalculator.getRootDistance(result, className, methodName);
        }
        if (value ? result.getTrace().getCoveredTrueBranches().contains(branch.getActualBranchId()) : result.getTrace().getCoveredFalseBranches().contains(branch.getActualBranchId())) {
            return new ControlFlowDistance(0, 0.0);
        }
        ControlFlowDistance nonRootDistance = ControlFlowDistanceCalculator.getNonRootDistance(result, branch, value);
        if (nonRootDistance == null) {
            throw new IllegalStateException("expect getNonRootDistance to never return null");
        }
        return nonRootDistance;
    }

    private static ControlFlowDistance getTimeoutDistance(ExecutionResult result, Branch branch) {
        if (!TestCoverageGoal.hasTimeout(result)) {
            throw new IllegalArgumentException("expect given result to have a timeout");
        }
        logger.debug("Has timeout!");
        return ControlFlowDistanceCalculator.worstPossibleDistanceForMethod(branch);
    }

    private static ControlFlowDistance worstPossibleDistanceForMethod(Branch branch) {
        ControlFlowDistance d = new ControlFlowDistance();
        if (branch == null) {
            d.setApproachLevel(20);
        } else {
            d.setApproachLevel(branch.getInstruction().getActualCFG().getDiameter() + 2);
        }
        return d;
    }

    private static boolean hasConstructorException(ExecutionResult result, String className, String methodName) {
        if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions()) {
            return false;
        }
        Integer exceptionPosition = result.getFirstPositionOfThrownException();
        if (!result.test.hasStatement(exceptionPosition)) {
            return false;
        }
        Statement statement = result.test.getStatement(exceptionPosition);
        if (statement instanceof ConstructorStatement) {
            ConstructorStatement c = (ConstructorStatement)statement;
            String constructorClassName = c.getConstructor().getName();
            String constructorMethodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            if (constructorClassName.equals(className) && constructorMethodName.equals(methodName)) {
                return true;
            }
        }
        return false;
    }

    private static ControlFlowDistance getRootDistance(ExecutionResult result, String className, String methodName) {
        ControlFlowDistance d = new ControlFlowDistance();
        if (result.getTrace().getCoveredMethods().contains(className + "." + methodName)) {
            return d;
        }
        if (ControlFlowDistanceCalculator.hasConstructorException(result, className, methodName)) {
            return d;
        }
        d.increaseApproachLevel();
        return d;
    }

    private static ControlFlowDistance getNonRootDistance(ExecutionResult result, Branch branch, boolean value) {
        if (branch == null) {
            throw new IllegalStateException("expect this method only to be called if this goal does not try to cover the root branch");
        }
        String className = branch.getClassName();
        String methodName = branch.getMethodName();
        ControlFlowDistance r = new ControlFlowDistance();
        r.setApproachLevel(branch.getInstruction().getActualCFG().getDiameter() + 1);
        for (MethodCall call : result.getTrace().getMethodCalls()) {
            HashSet<Branch> handled;
            ControlFlowDistance d2;
            if (!call.className.equals(className) || !call.methodName.equals(methodName) || (d2 = ControlFlowDistanceCalculator.getNonRootDistance(result, call, branch, value, className, methodName, handled = new HashSet<Branch>())).compareTo(r) >= 0) continue;
            r = d2;
        }
        return r;
    }

    private static ControlFlowDistance getNonRootDistance(ExecutionResult result, MethodCall call, Branch branch, boolean value, String className, String methodName, Set<Branch> handled) {
        if (branch == null) {
            throw new IllegalStateException("expect getNonRootDistance() to only be called if this goal's branch is not a root branch");
        }
        if (call == null) {
            throw new IllegalArgumentException("null given");
        }
        if (handled.contains(branch)) {
            return ControlFlowDistanceCalculator.worstPossibleDistanceForMethod(branch);
        }
        handled.add(branch);
        List<Double> trueDistances = call.trueDistanceTrace;
        List<Double> falseDistances = call.falseDistanceTrace;
        Set<Integer> branchTracePositions = ControlFlowDistanceCalculator.determineBranchTracePositions(call, branch);
        if (!branchTracePositions.isEmpty()) {
            ControlFlowDistance r = new ControlFlowDistance(0, Double.MAX_VALUE);
            for (Integer branchTracePosition : branchTracePositions) {
                if (value) {
                    r.setBranchDistance(Math.min(r.getBranchDistance(), trueDistances.get(branchTracePosition)));
                    continue;
                }
                r.setBranchDistance(Math.min(r.getBranchDistance(), falseDistances.get(branchTracePosition)));
            }
            if (r.getBranchDistance() == Double.MAX_VALUE) {
                throw new IllegalStateException("should be impossible");
            }
            return r;
        }
        ControlFlowDistance controlDependenceDistance = ControlFlowDistanceCalculator.getControlDependenceDistancesFor(result, call, branch.getInstruction(), className, methodName, handled);
        controlDependenceDistance.increaseApproachLevel();
        return controlDependenceDistance;
    }

    private static ControlFlowDistance getControlDependenceDistancesFor(ExecutionResult result, MethodCall call, BytecodeInstruction instruction, String className, String methodName, Set<Branch> handled) {
        Set<ControlFlowDistance> cdDistances = ControlFlowDistanceCalculator.getDistancesForControlDependentBranchesOf(result, call, instruction, className, methodName, handled);
        if (cdDistances == null) {
            throw new IllegalStateException("expect cdDistances to never be null");
        }
        return Collections.min(cdDistances);
    }

    private static Set<ControlFlowDistance> getDistancesForControlDependentBranchesOf(ExecutionResult result, MethodCall call, BytecodeInstruction instruction, String className, String methodName, Set<Branch> handled) {
        HashSet<ControlFlowDistance> r = new HashSet<ControlFlowDistance>();
        Set<ControlDependency> nextToLookAt = instruction.getControlDependencies();
        for (ControlDependency next : nextToLookAt) {
            if (instruction.equals(next.getBranch().getInstruction())) continue;
            boolean nextValue = next.getBranchExpressionValue();
            ControlFlowDistance nextDistance = ControlFlowDistanceCalculator.getNonRootDistance(result, call, next.getBranch(), nextValue, className, methodName, handled);
            assert (nextDistance != null);
            r.add(nextDistance);
        }
        if (r.isEmpty()) {
            r.add(new ControlFlowDistance());
        }
        return r;
    }

    private static Set<Integer> determineBranchTracePositions(MethodCall call, Branch branch) {
        HashSet<Integer> r = new HashSet<Integer>();
        List<Integer> path = call.branchTrace;
        for (int pos = 0; pos < path.size(); ++pos) {
            if (path.get(pos).intValue() != branch.getActualBranchId()) continue;
            r.add(pos);
        }
        return r;
    }
}

